@extends('layouts.app')

@section('title')
    @php
        $website_title = $user->username . ' albums on ' . $website_name;
    @endphp
@endsection

@section('content')

    <div class="row">
        <div class="col-md-8">
            <div class="user-profile user-profile-filled">
                <div class="user-profile-heading">
                    <div>
                        <span>albums</span>
                    </div>
                </div>
                <div class="user-profile-body">
                    @if($albums->count())
                        @foreach($albums as $album)
                            <div class="showtooltip col-md-55 @if($album->privacy) private @elseif(!$album->privacy && Auth::user() == $user) public @endif" data-tooltip-content="#tooltip_{{ $album->hash }}">
                                <a href="{{ url('/album') }}/{{ $album->hash }}" >
                                    @if($album->images->pluck('hash')->first())
                                    <img  src="{{url('thumb')}}/{{$album->images->pluck('hash')->first() }}.{{$album->images->pluck('extension')->first()}}">
                                    @else
                                        <img src="{{url('images/default.png')}}">
                                    @endif
                                </a>

                                <div class="tooltip_templates" hidden="false">
                                    <div id="tooltip_{{ $album->hash }}">
                                        <p>
                                        @if ($album->title)
                                            {{ $album->title }}
                                        @else
                                            Untitiled
                                        @endif
                                        </p>
                                        <div class="tooltip-bottom">{{$album->images->count()}} images · {{ $album->views }} views ·
                                            @if($album->published)
                                                {{$album->publishedAt()}}
                                            @else
                                                {{$album->createdAt()}}
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @else
                        @if(Auth::user() == $user)
                            You don't have any albums created yet.
                        @else
                            {{$user->username}}'s albums are not publicly available.
                        @endif
                    @endif
                </div>
            </div>
        </div>

        @include('user.sidebar')
@endsection
