<?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">
    @foreach ($albums as $album)
        <url>
            @if($enable_seo_for_published_albums == 'yes')
                <loc>{{ route('album.slug', $album->slug) }}</loc>
            @else
                <loc>{{ route('album.show', $album->hash) }}"</loc>
            @endif
            <lastmod>{{ $album->published_at->tz('UTC')->toAtomString() }}</lastmod>
            <changefreq>daily</changefreq>
            <priority>0.5</priority>
            @foreach ($album->images as $image)
                <image:image>
                    <image:loc>{{url($image->hash) }}.{{$image->extension}}</image:loc>
                    <image:title>{{$image->title}}</image:title>
                    <image:caption>{{$image->description}}</image:caption>
                </image:image>
            @endforeach
        </url>
    @endforeach
</urlset>
