@extends('layouts.app')

@section('content')
    <div class="row row-centered">
        <div class="{{$page->template}}">
            <div class="page page-filled">
                <div class="page-heading">
                    {{$page->name}}
                </div>
                <div class="page-body">
                    @if (Session::has('request.sent'))
                        <div class="alert alert-success alert-dismissible">
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('request.sent')}}
                        </div>
                    @else
                        <div style="margin-bottom: 25px;">
                            {!!$page->content!!}
                        </div>
                        <form action="{{ route('removalrequest.post') }}" method="POST" id="contactForm" novalidate>
                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                {{ csrf_field() }}
                                <label class="control-label" for="email">Email</label>
                                <input id="email" type="email" required value="" name="email" class="form-control">
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group{{ $errors->has('images') ? ' has-error' : '' }}">
                                {{ csrf_field() }}
                                <label class="control-label" for="images">List of images to be removed, separated by comma. Provide image hash names.</label>
                                <input id="images" type="text" placeholder="For example: KOGRxMe, tArZ1xM, 8Ip9wBs" required value="" name="images" class="form-control">
                                @if ($errors->has('images'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('images') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="form-group{{ $errors->has('message') ? ' has-error' : '' }}">
                                <label class="control-label" for="email">Why should these images be removed?</label>
                                <textarea class="form-control" required name="message" rows="8" cols="40"></textarea>
                                @if ($errors->has('message'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('message') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div style="margin: 20px; padding: 10px;">
                                <button class="btn btn-login right" type="submit">Send</button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@include('includes/footer')

@endsection
