@extends('layouts.app')

@section('content')
    <div class="row row-centered">
        <div class="{{$page->template}}">
            <div class="page page-filled">
                <div class="page-heading">
                    {{$page->name}}
                </div>

                <div class="page-body">
                    @if (Session::has('message.sent'))
                        <div class="alert alert-success alert-dismissible">
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('message.sent')}}
                        </div>
                    @else
                        <div style="margin-bottom: 25px;">
                            {!!$page->content!!}
                        </div>
                        <form action="{{ url('/contact') }}" method="POST" id="contactForm" novalidate>
                            <div class="form-group{{ $errors->has('email') ? ' has-error' : '' }}">
                                {{ csrf_field() }}
                                <label class="control-label" for="email">Email</label>
                                <input id="email" type="email" placeholder="Your email" title="Please enter you email" required value="" name="email" class="form-control">
                                @if ($errors->has('email'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div class="form-group{{ $errors->has('message') ? ' has-error' : '' }}">
                                <label class="control-label" for="email">Message</label>
                                <textarea class="form-control" placeholder="Your message" required name="message" rows="8" cols="40"></textarea>
                                @if ($errors->has('message'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('message') }}</strong>
                                    </span>
                                @endif
                            </div>

                            <div style="margin: 20px; padding: 10px;">
                                <button class="btn btn-login right" type="submit">Send</button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>
    </div>
@include('includes/footer')

@endsection
