@extends('layouts.app')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="page page-filled">
            <div class="page-heading">
                Upload new background
            </div>
            <div class="page-body">
                @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif
                <form method="post" id="uploadForm" enctype="multipart/form-data">
                    <div class="form-group">
                        <input type="text" class="form-control" style="width:50%;" name="title" placeholder="Give it a title" value="">
                    </div>
                    <div class="form-group">
                        <input type="file" name="file" id="file" class="inputfile" data-multiple-caption="{count} files selected"/>
                        <label for="file"><span>Choose a file&hellip;</span></label>
                    </div>
                    {{ csrf_field() }}
                </form>
            </div>
        </div>
    </div>
    @include('meme.sidebar')
</div>
@endsection

@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $("#uploadBtn").on("click", function(e){
            e.preventDefault();
            $('#uploadForm').attr('action', "{{ route('meme.new')}}").submit();
        });

    });
</script>
<script src="{{asset('js/custom-file-input.js')}}"></script>
@endsection
