@extends('layouts.app')

@section('css.scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fabric.js/1.6.5/fabric.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.3.6/css/bootstrap-colorpicker.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.3.6/js/bootstrap-colorpicker.min.js"></script>
    {{-- FONTS --}}
    <link href='https://fonts.googleapis.com/css?family=PT+Sans:700' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Montserrat:400' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Merriweather:700' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Raleway:800' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Source+Sans+Pro:900' rel='stylesheet' type='text/css'>
    <link href='https://fonts.googleapis.com/css?family=Permanent+Marker:400' rel='stylesheet' type='text/css'>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="page page-filled">
            <div class="page-heading row-centered">
            <form id="memeForm" method="post">
                {{ csrf_field() }}
                <div class="col-centered" style="padding-top:15px;">
                    <canvas id="canvas" width="{{$meme->width}}" height="{{$meme->height}}" style="border:0px solid white"></canvas>
                </div>
                <input type="hidden" id="meme" name="meme">
                <div class="image">
                    @if($meme->usermeme == false)
                        <img name="original" id="originalmeme" src="{{ url('memes/'.$meme->slug .'.'. $meme->extension) }}" style="display: none;" class="img-responsive center-block">
                    @else
                        <img name="original" id="originalmeme" src="{{ url('usermemes/'.$meme->slug .'.'. $meme->extension) }}" style="display: none;" class="img-responsive center-block">
                    @endif
                </div>
            </form>
            </div>
        </div>
    </div>
    @include('meme.sidebar')
</div>
<div class="row">
    <div class="PermanentMarker">
        PermanentMarker
    </div>
    <div class="SourceSansPro">
        SourceSansPro
    </div>
    <div class="Merriweather">
        Merriweather
    </div>
    <div class="Montserrat">
        Montserrat
    </div>
    <div class="PtSans">
        PT Sans
    </div>
    <div class="Raleway">
        Raleway
    </div>
</div>
@endsection

@section('scripts')
    <script>
    $(document).ready(function() {

        fabric.Textbox.prototype._wrapLine = function(ctx, text, lineIndex) {
            var lineWidth        = 0,
                lines            = [],
                line             = '',
                words            = text.split(' '),
                word             = '',
                letter           = '',
                offset           = 0,
                infix            = ' ',
                wordWidth        = 0,
                infixWidth       = 0,
                letterWidth      = 0,
                largestWordWidth = 0;

            for (var i = 0; i < words.length; i++) {
                word = words[i];
                wordWidth = this._measureText(ctx, word, lineIndex, offset);
                lineWidth += infixWidth;

                // Break Words if wordWidth is greater than textbox width
                if (this.breakWords && wordWidth > this.width) {
                    line += infix;
                    var wordLetters = word.split('');
                    while (wordLetters.length) {
                        letterWidth = this._getWidthOfChar(ctx, wordLetters[0], lineIndex, offset);
                        if (lineWidth + letterWidth > this.width) {
                            lines.push(line);
                            line = '';
                            lineWidth = 0;
                        }
                        line += wordLetters.shift();
                        offset++;
                        lineWidth += letterWidth;
                    }
                    word = '';
                } else {
                    lineWidth += wordWidth;
                }

                if (lineWidth >= this.width && line !== '') {
                    lines.push(line);
                    line = '';
                    lineWidth = wordWidth;
                }

                if (line !== '' || i === 1) {
                    line += infix;
                }
                line += word;
                offset += word.length;
                infixWidth = this._measureText(ctx, infix, lineIndex, offset);
                offset++;

                // keep track of largest word
                if (wordWidth > largestWordWidth && !this.breakWords) {
                    largestWordWidth = wordWidth;
                }
            }

            i && lines.push(line);

            if (largestWordWidth > this.dynamicMinWidth) {
                this.dynamicMinWidth = largestWordWidth;
            }

            return lines;
        }

        // var canvas = new fabric.Canvas('canvas');
        var canvas = window._canvas = new fabric.Canvas('canvas');
        canvas.selection = false;
        // var imgElement = document.getElementById('originalmeme');
        // var imgInstance = new fabric.Image(imgElement, {
        //   left: 0,
        //   top: 0,
        //   angle: 0,
        //   opacity: 1,
        //   selectable: false
        // });

        var imgElement = document.getElementById('originalmeme');
        var imgSource = imgElement.src;

        var imgInstance = fabric.Image.fromURL(imgSource, function(img) {
            img.set({top: 0, left: 0, angle: 0, opacity: 1, selectable: false});
            canvas.insertAt(img,0);
        });

        var topText = new fabric.Textbox('Top Text', {
                width: 600,
                lineHeight: 1,
                fontWeight: 'bold',
                fontSize: 70,
                stroke: '#000',
                strokeWidth: 2,
                fill: '#fff',
                textAlign: 'center',
                fontFamily: 'impact',
                breakWords: true
        });

        var topPos = canvas.height;
        var bottomText = new fabric.Textbox('Bottom Text', {
                width: 600,
                lineHeight: 1,
                fontWeight: 'bold',
                fontSize: 70,
                stroke: '#000',
                strokeWidth: 2,
                fill: '#fff',
                textAlign: 'center',
                fontFamily: 'impact',
                originY: 'bottom',
                left: 0,
                top: topPos,
                breakWords: true
        });


        // var topText = (new fabric.IText('Top Text', {
        //   fontFamily: 'impact',
        //   left: 200,
        //   top: 30 ,
        //   stroke: '#000',
        //   fill: '#fff',
        //   textAlign: 'center',
        //   fontSize: 70,
        // }));

        canvas.add(topText);
        canvas.add(bottomText);

        $('#font').on('change', function() {
            console.log("changing font: "+this.value);
            topText.set({fontFamily: this.value});
            bottomText.set({fontFamily: this.value});
            canvas.renderAll();
        });


        $('#top_text').on('change keyup keydown paste cut change', function() {
            topText.setText(this.value);
            canvas.renderAll();
        });

        $('#top_text_size').on('change', function() {
            topText.set({fontSize: this.value});
            canvas.renderAll();
        });

        $('#top_text_outline').on('change', function() {
            topText.set({strokeWidth: this.value});
            canvas.renderAll();
        });

        $(function() { $('#top_text_font_color').colorpicker(); });
        $('#top_text_font_color').colorpicker().on('changeColor', function() {
            topText.set({fill: $('#top_text_font_color').colorpicker('getValue')});
            canvas.renderAll();
            $('#top_text_font_color').attr('style', 'background-color: '+$('#top_text_font_color').colorpicker('getValue'));
        });

        $('#bottom_text').on('change keyup keydown paste cut change', function() {
            console.log('length: '+this.value.length);
            bottomText.setText(this.value);
            canvas.renderAll();
        });

        $(function() { $('#top_text_outline_color').colorpicker(); });
        $('#top_text_outline_color').colorpicker().on('changeColor', function() {
            topText.set({stroke: $('#top_text_outline_color').colorpicker('getValue')});
            canvas.renderAll();
            $('#top_text_outline_color').attr('style', 'background-color: '+$('#top_text_outline_color').colorpicker('getValue'));
        });

        $('#bottom_text_size').on('change', function() {
            bottomText.set({fontSize: this.value});
            canvas.renderAll();
        });

        $('#bottom_text_outline').on('change', function() {
            bottomText.set({strokeWidth: this.value});
            canvas.renderAll();
        });

        $(function() { $('#bottom_text_font_color').colorpicker(); });
        $('#bottom_text_font_color').colorpicker().on('changeColor', function() {
            bottomText.set({fill: $('#bottom_text_font_color').colorpicker('getValue')});
            canvas.renderAll();
            $('#bottom_text_font_color').attr('style', 'background-color: '+$('#bottom_text_font_color').colorpicker('getValue'));
        });

        $(function() { $('#bottom_text_outline_color').colorpicker(); });
        $('#bottom_text_outline_color').colorpicker().on('changeColor', function() {
            bottomText.set({stroke: $('#bottom_text_outline_color').colorpicker('getValue')});
            canvas.renderAll();
            $('#bottom_text_outline_color').attr('style', 'background-color: '+$('#bottom_text_outline_color').colorpicker('getValue'));
        });

        $("#saveMeme").on("click", function(e){
            var canvasImageData = canvas.toDataURL({
                    format: 'jpeg'
                });
            $('#meme').val(canvasImageData);

            e.preventDefault();
            $('#memeForm').attr('action', "{{ route('meme.save')}}").submit();
        });
    });
    </script>
@endsection
