
<div class="navbar navbar-default navbar-static-top">
    <div class="container">
        <div class="navbar-header">
            <!-- Branding Image -->
            <a class="navbar-brand" href="{{ url('/') }}">
                ImageShare.io
            </a>
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-main" aria-expanded="true">
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
            </button>
        </div>
        <div class="navbar-collapse collapse" id="navbar-main" aria-expanded="true">
          <ul class="nav navbar-nav">
            <li class="dropdown">
              <a href="#" data-toggle="modal" data-target="#uploadModal">Upload</a>
            </li>
          </ul>

          <ul class="nav navbar-nav navbar-right">
                @if (Auth::guest())
                    <li><a href="#" data-toggle="modal" data-target="#loginModal">Login</a></li>
                    <li><a href="#" data-toggle="modal" data-target="#registerModal">Register</a></li>
                @else
                    <li id="user-menu" class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-expanded="false">
                            {{ Auth::user()->username }} <span class="caret"></span>
                        </a>

                        <ul class="dropdown-menu" role="menu">
                            @role('admin')
                                <li>
                                    <a href="{{ url('/admin') }}">
                                        BackEnd
                                    </a>
                                </li>
                            @endrole
                            <li>
                                <a href="{{ url('/user') }}/{{Auth::user()->username}}">
                                    Profile
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/user') }}/{{Auth::user()->username}}/submitted">
                                    Submitted
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/user') }}/{{Auth::user()->username}}/favorites">
                                    Favorites
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/user') }}/{{Auth::user()->username}}/albums">
                                    Albums
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/user') }}/{{Auth::user()->username}}/images">
                                    Images
                                </a>
                            </li>
                            <li>
                                <a href="{{ url('/logout') }}"
                                    onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                                    Logout
                                </a>

                                <form id="logout-form" action="{{ url('/logout') }}" method="POST" style="display: none;">
                                    {{ csrf_field() }}
                                </form>
                            </li>
                        </ul>
                    </li>
                @endif
          </ul>

        </div>
    </div>
</div>

<div class="modal fade" id="uploadModal" tabindex="-1" role="dialog" hidden="true">
    <div class="modal-dialog upload-modal">
        <div class="modal-content">
            <div class="modal-body">
                <div class="row">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <br>
                <div class="row">
                    <form action="/album/upload" method="post" id="myAwesomeDropzone" class="dropzone">
                      <div id="dropzone-previews" class="dz-default dz-message">
                        <div id="uploadMsg" style="margin-bottom: 20px;"><i class="fa fa-cloud-upload"></i>
                            <h3>Drag and drop or click here</h3>to upload your images.
                            Max {{$max_upload_file_size}} MB per file. Max {{$max_upload_files}} files at once.
                        </div>
                      </div>
                        {{ csrf_field() }}
                    </form>
                </div>
                <div class="text-center" style="margin-bottom: 25px; margin-top: 25px;">
                    <button id="sbmtbtn" type="button" class="btn btn-upload">Upload</button>
                </div>
                <div class="text-center">
                    <a href="{{route('meme.index')}}" style="margin-right: 7px;">Meme Generator</a>
                    <a href="{{route('video2gif.upload')}}">Video to Gif</a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="loginModal" tabindex="-1" role="dialog" hidden="true">
    <div class="login-dialog">
        <div class="modal-content">
                <div class="panel panel-filled">
                    <div class="panel-body">
                        <form action="{{ url('/login') }}" method="POST" id="loginForm" novalidate>
                            <div class="form-group" id="email-div">
                                {{ csrf_field() }}
                                <label class="control-label" for="email">Email</label>
                                <input id="email" type="email" placeholder="example@gmail.com" title="Please enter you email" required value="" name="email" class="form-control">
                                {{-- <div id="form-errors-email" class="has-error"></div> --}}
                                <span class="help-block">
                                    <strong id="form-errors-email"></strong>
                                </span>
                                <span class="help-block small">Your email</span>
                            </div>
                            <div class="form-group" id="password-div">
                                <label class="control-label" for="password">Password</label>
                                <input type="password" title="Please enter your password" placeholder="******" required value="" name="password" id="password" class="form-control">
                                <span class="help-block">
                                    <strong id="form-errors-password"></strong>
                                </span>
                                <span class="help-block small">Your strong password</span>
                            </div>
                            <div class="form-group" id="login-errors">
                                <span class="help-block">
                                    <strong id="form-login-errors"></strong>
                                </span>
                            </div>
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="remember"> Remember Me
                                    </label>
                                </div>
                            </div>

                            <div>
                                <button class="btn btn-login right">Login</button>
                            </div>
                        </form>
                    </div>
                </div>
        </div>
    </div>
</div>


<div class="modal fade" id="registerModal" tabindex="-1" role="dialog" hidden="true">
    <div class="login-dialog">
        <div class="modal-content">
            <div class="panel panel-filled">
                <div class="panel-body">
                    <form action="{{ url('/register') }}" method="POST" id="registerForm">

                        <div class="form-group" id="register-username">
                            <label for="username" class="control-label">Username</label>
                                <input id="username" type="text" class="form-control" placeholder="choose username" required title="Please enter you username" name="username">
                                <span class="help-block">
                                    <strong id="register-errors-username"></strong>
                                </span>
                        </div>

                        <div class="form-group" id="register-email">
                            {{ csrf_field() }}
                            <label class="control-label" for="email">Email</label>
                            <input id="email" type="email" placeholder="example@gmail.com" title="Please enter you email" required value="" name="email" class="form-control">
                            <span class="help-block">
                                <strong id="register-errors-email"></strong>
                            </span>
                            <span class="help-block small">Your email</span>
                        </div>

                        <div class="form-group" id="register-password">
                            <label class="control-label" for="password">Password</label>
                            <input type="password" title="Please enter your password" placeholder="******" required value="" name="password" id="password" class="form-control">
                            <span class="help-block">
                                <strong id="register-errors-password"></strong>
                            </span>
                            <span class="help-block small">Your strong password</span>
                        </div>

                        <div class="form-group">
                            <label for="password-confirm" class="control-label">Confirm Password</label>
                            <input id="password-confirm" type="password" class="form-control" placeholder="******" name="password_confirmation">

                            <span class="help-block">
                                <strong id="form-errors-password-confirm"></strong>
                            </span>

                        </div>

                        <div class="form-group" id="login-errors">
                            <span class="help-block">
                                <strong id="form-login-errors"></strong>
                            </span>
                        </div>
                        <div>
                            <small>By registering you agree to our <a href="{{route('terms')}}" target="_blank">terms of service</a></small>
                            <button class="btn btn-login right">Register</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function(){

        if(!navigator.cookieEnabled){
            $( '#uploadMsg' ).html( "You have disabled cookies, upload will not work while cookies are disabled. Please enable cookies and refresh the page." );
        }

        var loginForm = $("#loginForm");
        loginForm.submit(function(e){
            e.preventDefault();
            var formData = loginForm.serialize();
            $( '#form-errors-email' ).html( "" );
            $( '#form-errors-password' ).html( "" );
            $( '#form-login-errors' ).html( "" );
            $("#email-div").removeClass("has-error");
            $("#password-div").removeClass("has-error");
            $("#login-errors").removeClass("has-error");

            $.ajax({
                url:'/login',
                type:'POST',
                data:formData,
                success:function(data){
                    $('#loginModal').modal( 'hide' );
                    location.reload(true);
                },
                error: function (data) {
                    console.log(data.responseText);
                    var obj = jQuery.parseJSON( data.responseText );
                    if(obj.email){
                        $("#email-div").addClass("has-error");
                        $( '#form-errors-email' ).html( obj.email );
                    }
                    if(obj.password){
                        $("#password-div").addClass("has-error");
                        $( '#form-errors-password' ).html( obj.password );
                    }
                    if(obj.error){
                        $("#login-errors").addClass("has-error");
                        $( '#form-login-errors' ).html( obj.error );
                    }
                }
            });
        });

        var registerForm = $("#registerForm");
        registerForm.submit(function(e){
            e.preventDefault();
            var formData = registerForm.serialize();
            $( '#register-errors-username' ).html( "" );
            $( '#register-errors-email' ).html( "" );
            $( '#register-errors-password' ).html( "" );
            $("#register-username").removeClass("has-error");
            $("#register-email").removeClass("has-error");
            $("#register-password").removeClass("has-error");

            $.ajax({
                url:'/register',
                type:'POST',
                data:formData,
                success:function(data){
                    $('#registerModal').modal( 'hide' );
                    location.reload(true);
                },
                error: function (data) {

                    console.log("we got error: ");
                    console.log(data.responseText);
                    var obj = jQuery.parseJSON( data.responseText );
                   if(obj.username){
                        $("#register-username").addClass("has-error");
                        $( '#register-errors-username' ).html( obj.username );
                    }
                    if(obj.email){
                        $("#register-email").addClass("has-error");
                        $( '#register-errors-email' ).html( obj.email );
                    }
                    if(obj.password){
                        $("#register-password").addClass("has-error");
                        $( '#register-errors-password' ).html( obj.password );
                    }
                    if(obj.error){
                        // $("#login-errors").addClass("has-error");
                        // $( '#form-login-errors' ).html( obj.error );
                    }
                }
            });
        });
    });
</script>
