<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- CSRF Token -->
<meta name="csrf-token" content="{{ csrf_token() }}">

{{-- <title>{{config('settings.title')}}</title> --}}

@include('includes.title')
<meta content="{{$website_keywords}}" name="keywords">
<meta name="robots" content="follow, index">
@include('includes.description')

<!-- Styles -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/3.3.6/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.5.0/css/font-awesome.min.css">

{{-- <link href="//fonts.googleapis.com/css?family=Raleway:400,300,600" rel="stylesheet" type="text/css"> --}}

<!-- App styles -->
<link rel="stylesheet" href="{{asset('css/sweetalert2.css')}}">
<link rel="stylesheet" href="{{asset('css/dropzone.css')}}">
<link rel="stylesheet" href="{{asset('css/tooltipster.core.css')}}">
<link rel="stylesheet" href="{{asset('css/style.css')}}?{{ str_random(7) }}">


<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.0.0/jquery.min.js"></script>
<script src="//cdnjs.cloudflare.com/ajax/libs/Sortable/1.4.2/Sortable.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/clipboard.js/1.5.12/clipboard.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.3.0/dropzone.js"></script>

<script src="{{asset('js/sweetalert2.js')}}?{{ str_random(7) }}"></script>
<script>
Dropzone.options.myAwesomeDropzone = {

    // Dropzone configuration
    autoProcessQueue: false,
    addRemoveLinks: true,
    uploadMultiple: true,
    parallelUploads: 100,
    maxFiles: {{$max_upload_files}},
    previewsContainer: '#dropzone-previews',
    // clickable:'#dropzone-previews',
    acceptedFiles: ".jpeg,.jpg,.png,.gif,.bmp",
    maxFilesize: {{$max_upload_file_size}},

    // The setting up of the dropzone
    init: function() {
    var myDropzone = this;

    myDropzone.on("addedfile", function(file) {
        $( '#uploadMsg' ).empty();
    });

    myDropzone.on("maxfilesexceeded", function(file) {
        $( '#uploadMsg' ).append('<h4>Max amount of files exceeded. Only '+{{$max_upload_files}}+' files can be uploaded at once.</h4>');
    });


    // First change the button to actually tell Dropzone to process the queue.
    $("#sbmtbtn").on('click',function(e) {
      // Make sure that the form isn't actually being sent.
          e.preventDefault();
          e.stopPropagation();
          myDropzone.processQueue();
        });

      // Listen to the sendingmultiple event. In this case, it's the sendingmultiple event instead
      // of the sending event because uploadMultiple is set to true.
      this.on("sendingmultiple", function() {
      // Gets triggered when the form is actually being sent.
      // Hide the success button or the complete form.
      });
      this.on("successmultiple", function(files, response) {
      // Gets triggered when the files have successfully been sent.
      // Redirect user or notify of success.
      window.location.href='/album/' + response;
      //alert(response);
      });
      this.on("errormultiple", function(files, response) {
      // alert('error');
      // Gets triggered when there was an error sending the files.
      // Maybe show form again, and notify user of error
      });
    }
}
</script>
<script src="{{asset('js/tooltipster.bundle.js')}}"></script>

<script>
    window.Laravel = <?php echo json_encode([
        'csrfToken' => csrf_token(),
    ]); ?>

    window.onresize = displayWindowSize;
    window.onload = displayWindowSize;
    function displayWindowSize() {
        // your size calculation code here
        document.getElementById("width").innerHTML = 'width: '+ window.innerWidth;
    };

</script>

<script>
    $(document).ready(function() {
        $('.showtooltip').tooltipster({
           animation: 'fade',
           delay: 200,
           side: ['bottom'],
           debug: false
        });
    });
</script>
