@extends('layouts.app')

@section('title')
    @php
        $website_description = $image->title . ' - ' . $website_name;
        $website_title = $image->title . ' - ' . $website_name;
    @endphp
@endsection

@section('description')
    <meta content="A {{$image->extension}} image, uploaded by {{$image->creator->username}}. {{$image->title}}" name="description">
@endsection

@section('css.scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.11.2/css/bootstrap-select.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.11.2/js/bootstrap-select.min.js"></script>

@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            <div class="album album-filled">
                <div class="album-heading">
                    @if ($owner)
                        <div class="post image-title limit" id="title" placeholder="Give this image a title" contenteditable="true">@if($image->title){{$image->title}}@endif</div>
                    @else
                        @if ($image->title)
                            <div class="image-title">
                                {{ $image->title }}
                            </div>
                        @endif
                        <div class="album-meta">
                            @if($image->privacy == 0)
                                @if($image->creator != null)
                                <span class="username">uploaded by
                                    <a href="{{url('user')}}/{{$image->creator->username }}">{{$image->creator->username}}</a>
                                </span>
                                @endif
                                <span class="album-posted" title="{{$image->created_at}}">{{$image->createdAt()}}</span>
                            @endif
                        </div>
                    @endif
                    <input type="hidden" id="image" name="image" value="{{ $image->hash }}">
                </div>

                <div class="image">
                    <img src="{{ url($image->hash) }}.{{ $image->extension }}" alt="" class="img-responsive center-block">
                </div>

                <div class="album-body">
                    @if ($owner)
                        <div class="post image-description" id="description" placeholder="Image description" contenteditable="true">@if($image->description){!! $image->description !!}@endif</div>
                    @else
                        @if ($image->description)
                            <div class="image-description">
                                {!! $image->description !!}
                            </div>
                        @endif
                    @endif
                </div>
            </div>
        </div>

        @include('image.sidebar')
    </div>
@if ($owner)
    <script type="text/javascript">
        $(document).ready(function() {
          $('.delete button').on('click', function() {
                swal({
                    title: 'Wait!',
                    text: "Are you sure you want to delete the image?",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Delete',
                    allowOutsideClick: false,
                    confirmButtonClass: 'btn btn-success',
                    cancelButtonClass: 'btn btn-danger'
                }).then(function() {
                    imageDelete(jQuery('#image').val());
                })

            });

            function imageDelete($image){
                $.ajax("/image/delete", {
                    method: 'POST',
                    dataType:'json',
                    data: {
                        hash: $image,
                        _token: Laravel.csrfToken
                    },
                    success: function(result) {
                      swal({
                        type: 'success',
                        title: 'Image has been deleted!',
                        allowOutsideClick: false
                      }).then(function() {
                              @if($image->creator != null)
                                window.location.href='user/{{ $image->creator->username }}/images';
                            @else
                                window.location.href='/album/';
                            @endif
                        })
                    },
                    error: function(result) {
                      swal({
                        type: 'error',
                        title: 'Something went wrong, image coult not be deleted!'
                      });
                    }
                });
            }

            $('.selectpicker').selectpicker();
            var $titleTimer = "";

            $('#title').keyup(function() {
                clearTimeout($titleTimer);
                $titleTimer = setTimeout(updateImage, 1000, jQuery('#title').text(), jQuery('#description').html(), jQuery('#image').val(), $('input[name="_token"]').val());
            });

            $('#description').keyup(function() {
                clearTimeout($titleTimer);
                $titleTimer = setTimeout(updateImage, 1000, jQuery('#title').text(), jQuery('#description').html(), jQuery('#image').val(), $('input[name="_token"]').val());
            });

            function updateImage($title, $description, $image, $token){
                var $description = $description.replace(/(<br\s*\/?>){3,}/gi, '<br><br>');
                    if($description == "<br>" || $description == "<br><br>"){
                        $description = "";
                    }
                    console.log("updateTitle");
                    jQuery.post("/image/save", {
                        title: $title,
                        description: $description,
                        image: $image,
                        _token: $token
                    }, function(data) {
                    });
            }
        });
    </script>
@endif
    <script type="text/javascript">

        $(document).ready(function() {
            var pre = document.getElementsByTagName('copy');

            for (var i = 0; i < pre.length; i++) {
                var isLanguage = pre[i].children[0].className.indexOf('copytext');

                if ( isLanguage === 0 ) {
                    var button           = document.createElement('button');
                            button.className = 'copy-button btn-copy';
                            button.textContent = 'Copy';

                            pre[i].appendChild(button);
                }
            };

        // 	// Run Clipboard

            var copyCode = new Clipboard('.copy-button', {
                target: function(trigger) {
                    return trigger.previousElementSibling;
            }
            });

            // On success:
            // - Change the "Copy" text to "Copied".
            // - Swap it to "Copy" in 2s.
            // - Lead user to the "contenteditable" area with Velocity scroll.

            copyCode.on('success', function(event) {
                event.clearSelection();
                event.trigger.textContent = 'Copied';
                event.trigger.previousElementSibling.select();
                window.setTimeout(function() {
                    event.trigger.textContent = 'Copy';
                }, 2000);
            });
        });
    </script>

@endsection
