@extends('layouts.app')

@section('title')
    @php
        if($tag)
            $topic = $tag->name;
        else
            $topic =  'No Topic';

        $website_description = 'Album with topic ' . $topic;
        if(isset($album->creator->username))
            $website_description .= ' uploaded by ' . $album->creator->username;
        $website_description .= '. ' . $album->title;
        $website_title = $album->title . ' - Album on ' . $website_name;
    @endphp
@endsection

@section('css.scripts')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.11.2/css/bootstrap-select.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.11.2/js/bootstrap-select.min.js"></script>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-8">
            @if(!empty($ad_unit_top))
                <div class="center-block" style="margin-bottom: 5px;">
                    {!!$ad_unit_top!!}
                </div>
            @endif
            @if (Session::has('album.publish'))
                <div class="alert alert-danger alert-dismissible">
                <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                <h4><i class="icon fa fa-check"></i> No, no!</h4>
                {{Session::pull('album.publish')}}
                </div>
            @endif

            <div class="album album-filled">
                <div class="album-heading">
                    @if ($owner && !$album->published)
                        <div class="post album-title limit" id="title" placeholder="Give this album a title" contenteditable="true">@if($album->title){{$album->title}}@endif</div>
                        <input type="hidden" id="album" name="album" value="{{ $album->hash }}">
                    @else
                        <div class="album-title">{{$album->title}}</div>
                        <div class="album-meta">
                            @if($album->creator != null)
                            <span class="username">by
                                <a href="{{url('user')}}/{{$album->creator->username }}">{{$album->creator->username}}</a>
                            </span>
                            @endif
                            @if($album->published)
                                <span class="album-posted" title="{{$album->created_at}}">{{$album->publishedAt()}}</span>
                            @else
                                <span class="album-posted" title="{{$album->created_at}}">{{$album->createdAt()}}</span>
                            @endif
                        </div>
                    @endif
                </div>
                @foreach ($album->images as $image)
                    {{-- <a href="{{ url($image->hash) }}.{{ $image->extension }}" data-lightbox="{{ $image->hash }}"> --}}
                    <div class="image">
                        <img src="{{ url($image->hash) }}.{{ $image->extension }}" alt="" class="img-responsive center-block">
                        @if ($owner && !$album->published)
                            <div class="overlay">
                                <copy>
                                    <input class="copytext form-control-copy" readonly type="text" value="{{ url($image->hash) }}">
                                </copy>
                            </div>
                        @endif
                    </div>
                    {{-- </a> --}}

                    <div class="album-body">
                        @if ($owner && !$album->published)
                            <div class="post image-title limit {{ $image->hash }}" id="title-{{ $image->hash }}" placeholder="Give this image a title" contenteditable="true">@if($image->title){{$image->title}}@endif</div>
                            <input type="hidden" id="image-{{ $image->hash }}" name="image-{{ $image->hash }}" value="{{ $image->hash }}">
                        @else
                            @if ($image->title)
                                <div class="image-title">
                                    {{ $image->title }}
                                </div>
                            @endif
                        @endif
                        @if ($owner && !$album->published)
                            <div class="post image-description {{ $image->hash }}" id="description-{{ $image->hash }}" placeholder="Image description" contenteditable="true">@if($image->description){!! $image->description !!}@endif</div>
                        @else
                            @if ($image->description)
                                <div class="image-description">
                                    {!! $image->description !!}
                                </div>
                            @endif
                        @endif
                    </div>
                @endforeach

                @if ($album->published)
                    <div class="album-body" style="padding-bottom: 5px;">
                        <div class="row">
                            <div class="col-sm-6 col-xs-6 pull-left votes-views">
                                @php
                                    $status = "";
                                    $favorited = "";
                                    if(Auth::user() != null){
                                        $status = $album->votes->where('user_id', Auth::user()->id)->pluck('status')->first();
                                        $favorited = $album->isFavoritedBy(Auth::user());
                                    }

                                    $user_id = 0;
                                    if(Auth::user() != null)
                                        $user_id = Auth::user()->id;
                                @endphp
                                <i id="icon-upvote" @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif class="icon-upvote @if($status == 'upvote')) icon-upvote-filled @endif" title="upvote"></i><i @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif id="icon-downvote" class="icon-downvote @if($status == 'downvote')) icon-downvote-filled @endif" title="downvote"></i><i @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif id="icon-heart" class="icon-heart @if($favorited) icon-heart-filled @endif" title="favorite"></i>
                                <div style="margin-top: 15px;">
                                    <span id="album-points" style="margin-right: 25px;">{{$album->getPointsAttribute()}} points</span>
                                    <span id="album-views">{{$album->views}} views</span>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xs-6 pull-left social-topic">
                                <div class="pull-right" style="margin-bottom: 15px;"><div class="addthis_inline_share_toolbox"></div></div>
                                <div style="clear: both;"></div>
                                <div class="pull-right dropdown">
                                    <span style="margin-top: 5px;" class="dropdown-toggle glyphicon glyphicon-option-horizontal" id="dropdownMenu-{{$album->id}}" data-toggle="dropdown"></span>
                                    <ul class="dropdown-menu" aria-labelledby="dropdownMenu-{{$album->id}}">
                                        <li><a id="reportAlbum" href="#">Report Album</a></li>
                                        <input type="hidden" id="id" value="{{$album->id}}">
                                    </ul>
                                 </div>
                                <div class="pull-right" style="margin-right: 10px;">
                                    @if($tag)
                                        <a style="color: white;" href="{{route('topic.all', $tag->slug)}}">{{$tag->name}}</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

            </div>
            @if ($album->published)
                <div class="panel panel-filled">
                    <div class="panel-body" style="padding-bottom: 0px;">
                        <form action="{{ url('/comment/add') }}" method="POST" id="commentForm">
                            {{ csrf_field() }}
                            <input type="hidden" id="album" name="album" value="{{$album->hash}}">
                            <textarea id="comment_textarea" class="form-control textarea-control" name="body" placeholder="Write a comment"></textarea>
                            <button id="comment-btn" class="btn btn-comment right" @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif disabled>Comment</button>
                            <div id="textarea_feedback" class="right" style="width: 100px; line-height: 50px;"></div>
                        </form>

                    </div>
                </div>

                <div id="comments" class="comments endless-pagination" data-next-page="{{ $comments->nextPageUrl() }}">
                    @include('album.comments')
                </div>
            @endif
        </div>
        @include('album.sidebar')

        <div id="reportHolder">
            <div class="whyreport">
                Why do you want to report this?
            </div>
            <div class="reason-options">
            @foreach($options as $option)
                 <label class="radio"><input type="radio" name="reason" value="{{$option->id}}"><small> {{$option->name}}</small></label>
            @endforeach
            </div>
            <div id="description" >
            @foreach($options as $option)
                <div id="reason-description-{{$option->id}}" class="reason-description hideme"><small>{{$option->description}}</small></div>
            @endforeach
            </div>
        </div>
@endsection

@section('scripts')

    <script type="text/javascript">
        $(document).ready(function() {
            this.imagePreview = function(){
               /* CONFIG */

                   xOffset = 15;
                   yOffset = 30;

                   // these 2 variable determine popup's distance from the cursor
                   // you might want to adjust to get the right result
                   var Mx = $(document).width();
                   var My = $(document).height();

               /* END CONFIG */
               var callback = function(event) {
                   var $img = $("#preview");

                   // top-right corner coords' offset
                   var trc_x = xOffset + $img.width();
                   var trc_y = yOffset + $img.height();

                   trc_x = Math.min(trc_x + event.pageX, Mx);
                   trc_y = Math.min(trc_y + event.pageY, My);


                   $img
                       .css("top", (trc_y - $img.height()) + "px")
                       .css("left", (trc_x - $img.width())+ "px");
               };
               $('a.preview').unbind();
               $("a.preview").hover(function(e){
                       Mx = $(document).width();
                       My = $(document).height();

                       this.t = this.title;
                       this.title = "";
                       var c = (this.t != "") ? "<br/>" + this.t : "";
                       $("body").append("<p id='preview'><img src='"+ this.href +"' alt='Image preview' />"+ c +"</p>");
                       callback(e);
                       $("#preview").fadeIn("fast");
                   },
                   function(){
                       this.title = this.t;
                       $("#preview").remove();
                   }
               )
               .mousemove(callback);
            };

            var id = null;
            var reasonId = null;
            var htmlReport = null;

            if($('#reportHolder').html() != null){
                htmlReport = $('#reportHolder').html();
            }
            $('#reportHolder').html('');

            function initAlbumReport(){
                $('#reportAlbum').on("click", function(event){
                    event.preventDefault();
                    swal({
                        title: 'Report Submission.',
                        // input: 'radio',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Report',
                        allowOutsideClick: false,
                        confirmButtonClass: 'btn btn-success',
                        cancelButtonClass: 'btn btn-danger',
                        html: htmlReport
                    }).then(function(result) {
                        if(reasonId != null){
                            $.ajax("/album/report", {
                                method: 'POST',
                                dataType:'json',
                                data: {
                                    id: jQuery('#id').val(),
                                    reason: reasonId,
                                    _token: Laravel.csrfToken
                                }
                                , success: function(result) {
                                    reasonId = null;
                                    swal({
                                        title: 'Report Submission.',
                                        text: "" + result.status,
                                        confirmButtonColor: '#3085d6',
                                        confirmButtonText: 'Close',
                                        allowOutsideClick: false,
                                        confirmButtonClass: 'btn btn-success'
                                    })
                                },
                                error: function(result) {
                                    reasonId = null;
                                    var response = jQuery.parseJSON( result.responseText );
                                    swal({
                                        title: 'Report Submission.',
                                        text: response.error,
                                        confirmButtonColor: '#3085d6',
                                        confirmButtonText: 'Close',
                                        allowOutsideClick: false,
                                        confirmButtonClass: 'btn btn-success'
                                    })
                                }
                            });
                        } else {
                            swal({
                                title: 'Report Submission.',
                                text: "You reported nothing, good on you!",
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'Close',
                                allowOutsideClick: true,
                                confirmButtonClass: 'btn btn-success'
                            })
                        }
                    })
                });
            }

            function initCommentReport(){
                $('[id^=reportComment-]').unbind();

                $('[id^=reportComment-]').on("click", function(event){
                    event.preventDefault();
                    // extract comment id
                    id = event.target.id.slice(14);
                    swal({
                        title: 'Report Submission.',
                        // input: 'radio',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Report',
                        allowOutsideClick: false,
                        confirmButtonClass: 'btn btn-success',
                        cancelButtonClass: 'btn btn-danger',
                        html:  htmlReport
                    }).then(function(result) {
                        if(reasonId != null){
                            $.ajax("/comment/report", {
                                method: 'POST',
                                dataType:'json',
                                data: {
                                    id: id,
                                    reason: reasonId,
                                    _token: Laravel.csrfToken
                                }
                                , success: function(result) {
                                    reasonId = null;
                                    swal({
                                        title: 'Report Submission.',
                                        text: "" + result.status,
                                        confirmButtonColor: '#3085d6',
                                        confirmButtonText: 'Close',
                                        allowOutsideClick: false,
                                        confirmButtonClass: 'btn btn-success'
                                    })
                                },
                                error: function(result) {
                                    reasonId = null;
                                    var response = jQuery.parseJSON( result.responseText );
                                    swal({
                                        title: 'Report Submission.',
                                        text: response.error,
                                        confirmButtonColor: '#3085d6',
                                        confirmButtonText: 'Close',
                                        allowOutsideClick: false,
                                        confirmButtonClass: 'btn btn-success'
                                    })
                                }
                            });
                        } else {
                            swal({
                                title: 'Report Submission.',
                                text: "You reported nothing, good on you!",
                                confirmButtonColor: '#3085d6',
                                confirmButtonText: 'Close',
                                allowOutsideClick: true,
                                confirmButtonClass: 'btn btn-success'
                            })
                        }
                    })
                });
            }

            initAlbumReport();
            initCommentReport();

            $(document).on("click",".swal2-container input[name='reason']", function() {
                reasonId = $('input[name=reason]:checked').val();
                // console.log('selected id: ' + reasonId);
                $("#description").children().hide();

                $("#reason-description-"+reasonId).show();
            });

            @if ($album->published)
                var commentForm = $("#commentForm");
                commentForm.submit(function(e){
                    e.preventDefault();
                    var formData = commentForm.serialize();
                    $.ajax({
                        url:'/comment/add',
                        type:'POST',
                        dataType:'json',
                        data:formData,
                        success:function(data){
                            $("#comments").prepend(data.comment);
                            $("#comment_textarea").val('');
                            imagePreview();
                        },
                        error: function (data) {
                            if(data.getResponseHeader('Retry-After') != null)
                            {
                                swal({
                                    title: 'Wait!',
                                    text: "You have exceeded maximum amount of comments you can make. You can try again after: "+ data.getResponseHeader('Retry-After')+" seconds",
                                    showCancelButton: false,
                                    confirmButtonColor: '#3085d6',
                                    cancelButtonColor: '#d33',
                                    confirmButtonText: 'Close',
                                    allowOutsideClick: false,
                                    confirmButtonClass: 'btn btn-success'
                                });
                                // console.log('ok');
                                // $("#comment_textarea").val('You can retry again after: ' + data.getResponseHeader('Retry-After'));
                            } else {
                                var response = jQuery.parseJSON( data.responseText );
                                swal({
                                    title: 'Wait!',
                                    text: "Something went wrong with comment submission. "+ response.error,
                                    showCancelButton: false,
                                    confirmButtonColor: '#3085d6',
                                    cancelButtonColor: '#d33',
                                    confirmButtonText: 'Close',
                                    allowOutsideClick: false,
                                    confirmButtonClass: 'btn btn-success'
                                });
                            }
                        }
                    });
                });

                function initCommentVote(){
                    $('[id^=vote_]').unbind();
                    $('[id^=downvote_]').unbind();
                    // UPVOTE
                    $('[id^=vote_]').click(
                        function(event) {
                            $(event.target).toggleClass("green");
                            var id = event.target.id.slice(5);
                            $('#comment_'+id).toggleClass('upvote');
                            var points = parseInt($('#comment_'+id).find('.points').text());
                            ++points;
                            if($(event.target).hasClass('green')){
                                $('#downvote_'+id).removeClass('red');
                                $('#comment_'+id).removeClass('downvote');
                                commentVote('upvote', id, $('input[name="_token"]').val(), points);
                            } else{
                                commentVote('neutral', id, $('input[name="_token"]').val(), points);
                            }
                        }
                    );
                    // DOWNVOTE
                    $('[id^=downvote_]').click(
                        function(event) {
                            $(event.target).toggleClass("red");
                            var id = event.target.id.slice(9);
                            $('#comment_'+id).toggleClass('downvote');
                            var points = parseInt($('#comment_'+id).find('.points').text());
                            --points;
                            if($(event.target).hasClass('red')){
                                $('#vote_'+id).removeClass('green');
                                $('#comment_'+id).removeClass('upvote');
                                commentVote('downvote', id, $('input[name="_token"]').val(), points);
                            } else{
                                commentVote('neutral', id, $('input[name="_token"]').val(), points);
                            }
                        }
                    );
                }

                initCommentVote();

                function commentVote($action, $comment, $token, $points){
                    $.ajax("/comment/vote", {
                        method: 'POST',
                        dataType:'json',
                        data: {
                            comment: $comment,
                            action: $action,
                            _token: $token
                        }
                        , success: function(result) {
                            $('#comment_'+$comment).find('.points').text(result.points+' pts');
                        },
                        error: function(result) {
                            $('#vote_'+$comment).removeClass('green');
                            $('#comment_'+$comment).removeClass('upvote');
                            $('#downvote_'+$comment).removeClass('red');
                            $('#comment_'+$comment).removeClass('downvote');
                        }
                    });
                }

                $('#icon-heart').click(function(){
                    $('#icon-heart').toggleClass('icon-heart-filled');
                    if($('#icon-heart').hasClass('icon-heart-filled')){
                        // $('#icon-downvote').removeClass('icon-downvote-filled');
                        favorite('favorite', jQuery('#album').val(), $('input[name="_token"]').val());
                    } else {
                        favorite('unfavorite', jQuery('#album').val(), $('input[name="_token"]').val());
                    }
                });

                function favorite($action, $album, $token){
                    $.ajax("/album/favorite", {
                        method: 'POST',
                        dataType:'json',
                        data: {
                            album: $album,
                            action: $action,
                            _token: $token
                        },
                        success: function(result) {
                        },
                        error: function(result) {
                            $('#icon-heart').removeClass('icon-heart-filled');
                        }
                    });
                }

                $('#icon-upvote').click(function(){
                    $('#icon-upvote').toggleClass('icon-upvote-filled');
                    if($('#icon-upvote').hasClass('icon-upvote-filled')){
                        $('#icon-downvote').removeClass('icon-downvote-filled');
                        // console.log('upvote');
                        albumVote('upvote', jQuery('#album').val(), $('input[name="_token"]').val());
                    } else {
                        albumVote('neutral', jQuery('#album').val(), $('input[name="_token"]').val());
                        // console.log('neutral');
                    }
                });

                $('#icon-downvote').click(function(){
                    $('#icon-downvote').toggleClass('icon-downvote-filled');
                    if($('#icon-downvote').hasClass('icon-downvote-filled')){
                        $('#icon-upvote').removeClass('icon-upvote-filled');
                        $('#icon-heart').removeClass('icon-heart-filled');
                        albumVote('downvote', jQuery('#album').val(), $('input[name="_token"]').val());
                        // console.log('downvote');
                    } else {
                        albumVote('neutral', jQuery('#album').val(), $('input[name="_token"]').val());
                        // console.log('neutral');
                    }
                });

                function albumVote($action, $album, $token){
                    $.ajax("/album/vote", {
                        method: 'POST',
                        dataType:'json',
                        data: {
                            album: $album,
                            action: $action,
                            _token: $token
                        },
                        success: function(result) {
                            $('#album-points').text(result.points+' points');
                        },
                        error: function(result) {
                            $('#icon-upvote').removeClass('icon-upvote-filled');
                            $('#icon-downvote').removeClass('icon-downvote-filled');
                        }
                    });
                }

                function h(e) {
                    $(e).css({'height':'20px','overflow-y':'hidden'}).height(e.scrollHeight);
                }

                $('textarea').each(function () {
                  h(this);
                }).on('input', function () {
                  h(this);
                });

                var text_max = 140;
                $('#textarea_feedback').html(text_max +' char left');

                $("#comment_textarea").on("keyup keydown",function() {countCharacters();});
                $('#comment_textarea').on('paste cut change', function () {
                  setTimeout(function () {
                    countCharacters();
                  }, 100);
                });

                countCharacters();

                function countCharacters(){
                    var text_length = $('#comment_textarea').val().length;
                    var text_remaining = text_max - text_length;

                    if(text_remaining < 140){
                        $('#comment-btn').prop("disabled",false);
                    }

                    if(text_remaining <= -1){
                        $('#comment-btn').prop("disabled",true);
                    }

                    if(text_remaining == 140){
                        $('#comment-btn').prop("disabled",true);
                    }

                    $('#textarea_feedback').html(text_remaining + ' char left');
                }

                $(window).scroll(fetchComments);
                function fetchComments() {
                    var page = $('.endless-pagination').data('next-page');
                    // console.log('fetchComments');

                    if(page !== null && page !== "") {
                        clearTimeout( $.data( this, "scrollCheck" ) );
                        $.data( this, "scrollCheck", setTimeout(function() {
                            var scroll_position_for_comments_load = $(window).height() + $(window).scrollTop() + 100;

                            if(scroll_position_for_comments_load >= $(document).height()) {
                                $.get(page, function(data){
                                    $('.comments').append(data.comments);
                                    $('.endless-pagination').data('next-page', data.next_page);
                                    initCommentVote();
                                    initCommentReport();
                                    imagePreview();
                                });
                            }
                        }, 350))
                    }
                }
            @endif
        });
    </script>

    @if ($owner)
    <script type="text/javascript">
        $(document).ready(function() {

            var pre = document.getElementsByTagName('copy');

            for (var i = 0; i < pre.length; i++) {
                var isLanguage = pre[i].children[0].className.indexOf('copytext');

                if ( isLanguage === 0 ) {
                    var button           = document.createElement('button');
                            button.className = 'copy-button btn btn-copy';
                            button.textContent = 'Copy';

                            pre[i].appendChild(button);
                }
            };

        // 	// Run Clipboard

            var copyCode = new Clipboard('.copy-button', {
                target: function(trigger) {
                    return trigger.previousElementSibling;
            }
            });

            // On success:
            // - Change the "Copy" text to "Copied".
            // - Swap it to "Copy" in 2s.
            // - Lead user to the "contenteditable" area with Velocity scroll.

            copyCode.on('success', function(event) {
                event.clearSelection();
                event.trigger.textContent = 'Copied';
                event.trigger.previousElementSibling.select();
                window.setTimeout(function() {
                    event.trigger.textContent = 'Copy';
                }, 2000);
            });
        });
    </script>

    <script type="text/javascript">
        $(document).ready(function() {

             $('.delete button').on('click', function() {
                swal({
                    title: 'Wait!',
                    text: "Are you sure you want to delete this album?",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Delete',
                    allowOutsideClick: false,
                    confirmButtonClass: 'btn btn-success',
                    cancelButtonClass: 'btn btn-danger'
                }).then(function() {
                    albumDelete(jQuery('#album').val());
                })
            });

            $privacy_options = null;
            $privacy_description = null;

            $('.privacy button').on('click', function() {

                $.ajax("/album/privacy", {
                    method: 'get',
                    dataType:'json',
                    data: {
                        album: jQuery('#album').val(),
                        _token: Laravel.csrfToken
                    },
                    success: function(result) {
                        if($privacy_options == null){
                            $privacy_options = $('#privacy_options').html();
                            $('#privacy_options').html('');
                        }

                        $html = $privacy_options;

                        if($privacy_description == null){
                            $privacy_description = $('#privacy_description').html();
                            $('#privacy_description').html('');
                        }

                        $html += $privacy_description;

                        swal({
                            type: 'info',
                            title: '<i>Chooose privacy setting</i>',
                            html: $html,
                            showCloseButton: true,
                            confirmButtonText: 'Save',
                            }).then(function() {
                            albumPrivacy(jQuery('#album').val(), $('input[name=privacy]:checked').val());
                        });

                        if(result.privacy == 1){
                            $('#public').attr('checked', 'false');
                            $('#private').attr('checked', 'true');
                            $(".private_description").show();
                        } else{
                            $('#private').attr('checked', 'false');
                            $('#public').attr('checked', 'true');
                            $(".public_description").show();
                        }

                        $('input[type="radio"]').click(function(){
                            if($(this).attr("value")==1){
                                $(".public_description").hide();
                                $(".private_description").show();
                            }
                            if($(this).attr("value")==0){
                                $(".public_description").show();
                                $(".private_description").hide();
                            }
                        });

                    },
                    error: function(result) {
                      swal({
                        type: 'error',
                        title: 'Something went wrong, <br> could not update album privacy!'
                      });
                    }
                });

            });

            function albumPrivacy($album, $privacy){
                // ('privacy ' + $privacy);
                $.ajax("/album/privacy", {
                    method: 'POST',
                    dataType:'json',
                    data: {
                        album: $album,
                        privacy: $privacy,
                        _token: Laravel.csrfToken
                    },
                    success: function(result) {
                    },
                    error: function(result) {
                      swal({
                        type: 'error',
                        title: 'Something went wrong, <br> could not update album privacy!'
                      });
                    }
                });
            }

            function albumDelete($album){
                $.ajax("/album/delete", {
                    method: 'POST',
                    dataType:'json',
                    data: {
                        album: $album,
                        _token: Laravel.csrfToken
                    },
                    success: function(result) {
                      swal({
                        type: 'success',
                        title: 'Album has been deleted!',
                        allowOutsideClick: false
                      }).then(function() {
                              @if($album->creator != null)
                                window.location.href='{{url('user')}}/{{ $album->creator->username }}/albums';
                            @else
                                window.location.href='/album/';
                            @endif
                        })
                    },
                    error: function(result) {
                      swal({
                        type: 'error',
                        title: 'Something went wrong, album could not be deleted!'
                      });
                    }
                });
            }

            $("#shareForm").submit(function(e){
                console.log('topic: '+jQuery('#topic').val());
                if ($('#title').text() == ""){
                    $("#registerModal").modal('hide');
                    e.preventDefault();
                    swal({
                        title: 'Wait!',
                        text: "You gotta give this album a name, <br> before you can share it!",
                        confirmButtonColor: '#3085d6',
                        confirmButtonText: 'Ok',
                        allowOutsideClick: false
                    });
                } else{
                    jQuery('#albumTitle').val(jQuery('#title').text());
                    jQuery('#albumTopic').val(jQuery('#topic').val());
                }
                @if(Auth::user() == null)
                    e.preventDefault();
                @endif
            });

            jQuery(function($){
                $(".post").focusout(function(){
                    var element = $(this);
                    // console.log(element.text());
                    // console.log(element.text().replace(" ", "").length);
                    if (!element.text().replace(" ", "").length) {

                        element.empty();
                    }
                });
            });

            $(".limit").keypress(function(e){ return e.which != 13; });

            $('.limit').on('keydown', function(event) {
              if($(this).text().length === 100 && event.keyCode != 8) {
                  event.preventDefault();
              }
            });

            var $titleTimer = "";
            $('#title').on('keyup', function() {
                // console.log("title");
                clearTimeout($titleTimer);
                if ($('#title').text() != "")
                    $titleTimer = setTimeout(updateAlbumTitle, 100, jQuery('#title').text(), jQuery('#album').val());
            });

            function updateAlbumTitle($title, $album){
                jQuery.post("/album/savetitle", {
                    title: $title,
                    album: $album,
                    _token: Laravel.csrfToken
                }, function(data) {
                });
            }

            var $timer = "";
            $('[id^=title-]').keyup(
                function(event) {
                    var $hash = event.target.id.slice(6);
                    // console.log('hash: ' + $hash);
                    clearTimeout($timer);
                    $timer = setTimeout(updateImageData, 100, jQuery('#title-'+$hash).text(), jQuery('#description-'+$hash).html(), jQuery('#image-'+$hash).val());
                }
            );

            $('[id^=description-]').keyup(
                function(event) {
                    var $hash = event.target.id.slice(12);
                    // console.log('hash: ' + $hash);
                    clearTimeout($timer);
                    $timer = setTimeout(updateImageData, 100, jQuery('#title-'+$hash).text(), jQuery('#description-'+$hash).html(), jQuery('#image-'+$hash).val());
                }
            );

            function updateImageData($title, $description, $image) {
                var $description = $description.replace(/(<br\s*\/?>){3,}/gi, '<br><br>');
                // console.log("desc:"+$description);
                if($description == "<br>" || $description == "<br><br>"){
                    $description = "";
                }
                jQuery.post("/image/save", {
                    title: $title,
                    description: $description,
                    image: $image,
                    _token: Laravel.csrfToken
                }, function(data) {
                });
            }
        });
    </script>
    @endif
@endsection
