@extends('layouts.app')

@section('content')

    <div class="row">
        <div class="col-md-8">
            <div class="panel panel-filled">
                <div class="panel-body">
                    <div class="row" id="album">
                        @foreach ($album->images as $image)
                            <div id="reorder-images" class="col-md-55 cursor">
                                <img id="{{$image->id}}" src="{{url('thumb')}}/{{$image->hash}}.{{$image->extension}}" style="width: 143px; height: 143px; ">
                            </div>
                        @endforeach
                    </div>
                </div>

            </div>
        </div>

        <div id="sidebar" class="col-md-4 rightpadding">
        <!-- sidebar nav -->
                <nav id="sidebar-nav">
                {{-- @if ($owner) --}}
                    <div class="panel panel-filled">
                        <div class="panel-body">
                            <ul class="usermenu">
                                <li>
                                    <a href="javascript:void(0);" id="save" role="button"><button class="btn" type="submit">Save Order</button></a>
                                </li>
                            </ul>
                        </div>
                    </div>
                {{-- @endif --}}
                </nav>
        </div>
    </div>
    <script type="text/javascript">
    $(document).ready(function(){

            Sortable.create(album, { /* options */ });

            $("#save").click(function( e ){
                e.preventDefault();

                var h = [];
                $("#reorder-images img").each(function() {  h.push($(this).attr('id'));  });
                $.ajax({
                    type: "POST",
                    url: "reorder",
                    data: {
                        ids: h,
                        _token: Laravel.csrfToken
                    },
                    success: function(response)
                    {
                        window.location.href='/album/' + response;
                    }
                });
                return false;
            });
    });
    </script>

@endsection
