@extends('layouts.app')

@section('css.scripts')
    <link rel="stylesheet" href="{{asset('css/frontpage.css')}}?{{ str_random(7) }}">
@endsection

@section('content')
    <div class="row row-centered">
        <div class="col-md-12" style="margin-bottom: 20px;">
                <div id="sorting" class="sorting-sentance">
                    <span id="pre-sentance">
                        @if($routeName == 'topic')
                            Images tagged as
                        @else
                            The
                        @endif
                    </span>
                    <div class="select-sorting dropdown">
                      <button class="dropdown-toggle" type="button" id="firstSort" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                        @if($routeName == 'topic')
                            {{$tag->name}}
                        @else
                            Most Viral
                        @endif
                      </button>
                      <ul class="dropdown-menu" aria-labelledby="firstSort">
                          @if($routeName == 'topic')
                              <li style="border-bottom: 1px solid #ddd;"><a href="{{route('topic.all',$tag->slug)}}"><div class="current-sort">current: </div><div class="selected-sort">{{$tag->name}}</div></a></li>
                              <li style="border-bottom: 1px solid #ddd;"><a href="{{route('viral.all')}}">Most Viral</a></li>
                          @else
                              <li style="border-bottom: 1px solid #ddd;"><a href="{{route('viral.all')}}"><div class="current-sort">current: </div><div class="selected-sort">Most Viral</div></a></li>
                          @endif

                        @foreach ($tags as $tagone)
                            <li><a href="{{route('topic.all', $tagone->slug)}}">{{$tagone->name}}</a></li>
                        @endforeach
                      </ul>
                    </div>
                    <span id="middle-sentance">
                        @if($routeName == 'topic')
                            sorted by
                        @else
                            images on the Internet, sorted by
                        @endif
                    </span>
                    <div class="select-sorting dropdown">
                      <button class="dropdown-toggle" type="button" id="secondSort" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                          @php
                          $current = "highest scoring";
                          $route = $routeName.'.'.$time;
                              switch ($time) {
                                  case 'popularity':
                                      $current =  "popularity";
                                  break;
                                  case 'newest':
                                      $current =  "newest first";
                                  break;
                                  case 'random':
                                      $current =  "random";
                                  break;
                              }
                              echo $current;
                          @endphp

                      </button>
                      <ul class="dropdown-menu" aria-labelledby="secondSort">
                            @if($routeName == 'topic')
                                <li><a href="{{route($route,$tag->slug)}}"><div class="current-sort">current: </div><div class="selected-sort">{{$current}}</div></a></li>
                                <li><a href="{{route('topic.all',$tag->slug)}}">highest scoring</a></li>
                                <li><a href="{{route('topic.popularity',$tag->slug)}}">popularity</a></li>
                                <li><a href="{{route('topic.newest',$tag->slug)}}">newest first</a></li>
                                <li><a href="{{route('topic.random',$tag->slug)}}">random</a></li>
                            @else
                                <li><a href="{{route($route)}}"><div class="current-sort">current: </div><div class="selected-sort">{{$current}}</div></a></li>
                                <li><a href="{{route('viral.all')}}">highest scoring</a></li>
                                <li><a href="{{route('viral.popularity')}}">popularity</a></li>
                                <li><a href="{{route('viral.newest')}}">newest first</a></li>
                                <li><a href="{{route('viral.random')}}">random</a></li>
                            @endif

                      </ul>
                    </div>

                    @if($current == 'highest scoring')
                        <span id="middle-sentance">
                            of
                        </span>

                        <div class="select-sorting dropdown">
                          <button class="dropdown-toggle" type="button" id="secondSort" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                            @php
                                switch ($time) {
                                    case 'all':
                                        echo "all time";
                                    break;
                                    case 'today':
                                        echo "today";
                                    break;
                                    case 'week':
                                        echo "this week";
                                    break;
                                    case 'month':
                                        echo "this month";
                                    break;
                                    case 'year':
                                        echo "this year";
                                    break;
                                }
                            @endphp
                          </button>
                          <ul class="dropdown-menu" aria-labelledby="secondSort">
                                @if($routeName == 'topic')
                                    @php
                                        $current = 'all time';
                                        $route = $routeName.'.'.$time;
                                        switch ($time) {
                                            case 'all':
                                                $current = "all time";
                                            break;
                                            case 'today':
                                                $current = "today";
                                            break;
                                            case 'week':
                                                $current = "this week";
                                            break;
                                            case 'month':
                                                $current = "this month";
                                            break;
                                            case 'year':
                                                $current = "this year";
                                            break;
                                        }
                                    @endphp
                                    <li><a href="{{route($route,$tag->slug)}}"><div class="current-sort">current: </div><div class="selected-sort">
                                        {{$current}}
                                    </div></a></li>
                                    <li><a href="{{route('topic.today',$tag->slug)}}">today</a></li>
                                    <li><a href="{{route('topic.week',$tag->slug)}}">this week</a></li>
                                    <li><a href="{{route('topic.month',$tag->slug)}}">this month</a></li>
                                    <li><a href="{{route('topic.year',$tag->slug)}}">this year</a></li>
                                    <li><a href="{{route('topic.all',$tag->slug)}}">all time</a></li>
                                @else
                                    <li><a href="{{route('viral.all')}}"><div class="current-sort">current: </div><div class="selected-sort">all time</div></a></li>
                                    <li><a href="{{route('viral.today')}}">today</a></li>
                                    <li><a href="{{route('viral.week')}}">this week</a></li>
                                    <li><a href="{{route('viral.month')}}">this month</a></li>
                                    <li><a href="{{route('viral.year')}}">this year</a></li>
                                    <li><a href="{{route('viral.all')}}">all time</a></li>
                                @endif
                          </ul>
                        </div>
                    @endif
                    @if($routeName == 'topic')
                        <div style="margin-top: 12px; font-size: 13px; color: #999;">
                            @if($current == 'popularity') {{$popularityTime}} most popular albums for @endif {{$tag->description}}
                        </div>
                    @elseif($current == 'popularity')
                        <div style="margin-top: 12px; font-size: 13px; color: #999;">
                            {{$popularityTime}} most popular albums.
                        </div>
                    @endif
                </div>
        </div>
        <div class="col-md-12">
            <div class="panel panel-filled">
                <div class="panel-body endless-pagination" data-next-page="{{ $albums->nextPageUrl() }}">
                    {{-- <div class="row"> --}}
                        @foreach ($albums as $albumshow)
                            <div class="showtooltip col-md-55" data-tooltip-content="#tooltip_{{ $albumshow->hash }}">
                                @if($enable_seo_for_published_albums == 'yes')
                                    <a href="{{ route('album.slug', $albumshow->slug) }}" >
                                @else
                                    <a href="{{ route('album.show', $albumshow->hash) }}" >
                                @endif

                                    @if($albumshow->images->pluck('hash')->first())
                                        {{-- <img  src="{{url('thumb')}}/{{$album->images->pluck('hash')->first() }}.{{$albumshow->images->pluck('extension')->first()}}"> --}}
                                        <img class="image-thumb" src="{{url($albumshow->images->pluck('path')->first())}}/thumb/{{$albumshow->images->pluck('hash')->first() }}.{{$albumshow->images->pluck('extension')->first()}}">
                                    @else
                                        <img  src="{{url('images/default.png')}}">
                                    @endif
                                </a>

                                <div class="tooltip_templates" hidden="false">
                                    <div id="tooltip_{{ $albumshow->hash }}">
                                        <p>
                                        {{ $albumshow->title }}
                                        </p>
                                        <div class="tooltip-bottom">{{ $albumshow->getPointsAttribute() }} points · {{ $albumshow->views }} views · {{ $albumshow->publishedAt() }}</div>
                                    </div>
                                </div>

                            </div>
                        @endforeach
                    {{-- </div> --}}
                    <div style="clear: both;"></div>
                    @if($pagination == 'links')
                        <div class="text-center">
                            {{$albums->links()}}
                        </div>
                    @endif
                </div>
            </div>
            @include('includes/footer')
        </div>
        <script>
            $(document).ready(function() {
                $( "#speed" ).selectmenu();
                @if($pagination == 'infinite')
                    $(window).scroll(fetchPosts);
                    function fetchPosts() {
                        var page = $('.endless-pagination').data('next-page');

                        if(page !== null && page !== "") {
                            clearTimeout( $.data( this, "scrollCheck" ) );
                            $.data( this, "scrollCheck", setTimeout(function() {
                                var scroll_position_for_posts_load = $(window).height() + $(window).scrollTop() + 100;

                                if(scroll_position_for_posts_load >= $(document).height()) {
                                    $.get(page, function(data){
                                        $('.endless-pagination').append(data.posts);
                                        $('.endless-pagination').data('next-page', data.next_page);

                                        $('.showtooltip').tooltipster({
                                           animation: 'fade',
                                           delay: 200,
                                           side: 'bottom',
                                           debug: false
                                        });
                                    });
                                }
                            }, 350))
                        }
                    }
                @endif
            });
        </script>
@endsection
