@php
    $user_id = 0;
    if(Auth::user() != null)
        $user_id = Auth::user()->id;
@endphp
@if(!empty($ad_unit_comments_top))
    <div class="center-block" style="margin-bottom: 20px;">
        {!!$ad_unit_comments_top!!}
    </div>
@endif
@foreach ($comments as $comment)
    @php
        $status = $comment->votes->where('user_id', $user_id)->pluck('status')->first();
    @endphp

        <div class="comment comment-filled {{$status}}" style="position: relative;" id="comment_{{$comment->id}}">
            <div class="comment-heading">
                <span class="username left">
                    <a href="{{url('user')}}/{{$comment->creator->username }}">{{$comment->creator->username}}</a>
                </span>
                <span class="points left">{{$comment->getPointsAttribute()}} pts</span>
                <span class="left" title="{{$comment->created_at}}">{{ $comment->createdAt() }}</span>
                <div class="dropdown left">
                    <span class="dropdown-toggle glyphicon glyphicon-option-horizontal" id="dropdownMenu-{{$comment->id}}" data-toggle="dropdown"></span>
                    <ul class="dropdown-menu" aria-labelledby="dropdownMenu-{{$comment->id}}">
                        <li><a id="reportComment-{{$comment->id}}" href="#">Report</a></li>
                    </ul>
                 </div>
                <div style="clear: both;"></div>
            </div>
            <div class="comment-body" id="comment-body-"{{$comment->id}}>
                {!!$comment->body!!}
            </div>

            <div class="comment-votes">
                <span id="vote_{{$comment->id}}" @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif style='font-size:1.9em;' class="glyphicon glyphicon-circle-arrow-up @if($status == 'upvote') green @endif"></span>
                <span id="downvote_{{$comment->id}}" @if($user_id == 0) data-toggle='modal' data-target='#registerModal' @endif style='font-size:1.9em;' class="glyphicon glyphicon-circle-arrow-down @if($status == 'downvote') red @endif"></span>
            </div>
        </div>
@endforeach
