@extends('layouts.admin')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                  <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Tags</h3>
                        <div class="box-tools">
                            <a href="{{ route('admin.tags.create')}}"><button class="btn btn-block btn-primary" type="submit" value="Add New"><i class="fa fa-fw fa-plus"></i> Add New</button></a>
                        </div>
                    </div>

                    @include('admin.tags.message')
                    <!-- /.box-header -->
                    <div class="box-body">
                        <table id="example2" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($tags as $tag)
                                <tr>
                                    <td style="width: 50px;">{{$tag->id}}</td>
                                    <td><a href="/admin/tags/edit/{{$tag->id}}">{{$tag->name}}</a></td>
                                    <td style="width: 150px;">
                                    <form role="form" id="deleteForm-{{ $tag->id }}" method="post" action="tags/delete">
                                        <input type="hidden" value="{{ $tag->id }}" id="id" name="id" class="form-control">
                                        {{ csrf_field() }}
                                        <button id="deleteBtn-{{ $tag->id }}" class="btn btn-xs btn-danger" type="submit"><i class="fa fa-trash"></i> Delete</button>
                                    </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Id</th>
                                    <th>Name</th>
                                    <th>Actions</th>
                                </tr>
                            </tfoot>
                        </table>
                        {{ $tags->links() }}
                    </div>
                    <!-- /.box-body -->
                  </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $('[id^=deleteBtn-]').on("click", function(event){
            console.log('test');
            event.preventDefault();
            var id = event.target.id.slice(10);
            swal({
                title: 'Wait!',
                text: "Are you sure you want to delete this tag?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Delete',
                allowOutsideClick: false,
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger'
            }).then(function() {
                $("#deleteForm-"+id).attr('action', "{{ route('admin.tags.delete')}}").submit();
            })
        });
    });
</script>
@endsection
