@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Update Tag</h3>
                        </div>
                        <form role="form" id="tagForm" method="post">
                            @if (count($errors) > 0)
                                <div class="alert alert-danger">
                                    <ul>
                                        @foreach ($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif
                            <div class="box-body">
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <label for="title">Title</label>
                                    <input type="hidden" value="{{ $tag->id }}" id="id" name="id" class="form-control">
                                    <input type="text" placeholder="Enter tag title" value="{{ $tag->name }}" id="name" name="name" class="form-control">
                                </div>
                                <div class="form-group">
                                    <label for="slug">Slug</label>
                                    <input type="text" id="slug" value="{{ $tag->slug }}"  name="slug" class="form-control" disabled="true">
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                        <div class="box-body">
                            <div class="form-group">
                                <button id="tagBtn" class="btn btn-primary pull-right" type="submit">Save</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $("#tagBtn").on("click", function(e){
            e.preventDefault();
            $('#tagForm').attr('action', "{{ route('admin.tags.update')}}").submit();
        });

    });
</script>

@endsection
