@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add New Tag</h3>
                        </div>
                        <form role="form" id="tagForm" method="post">
                            <div class="box-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <label for="exampleInputEmail1">Name</label>
                                    <input type="text" placeholder="Enter tag name" id="title" name="name" class="form-control">
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <button id="createBtn" class="btn btn-primary pull-right" type="submit">Create</button>
                            </div>

                            <div class="box-footer">

                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {
        $("#createBtn").on("click", function(e){
            e.preventDefault();
            $('#tagForm').attr('action', "{{route('admin.tags.store')}}").submit();
        });
    });
</script>

@endsection
