@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Settings - Ads</h3>
                    </div>
                    <form action="{{route('admin.settings.ads.save')}}" method="post">
                        <div class="box-body">
                            @if (Session::has('settings.save'))
                                <div class="alert alert-success alert-dismissible">
                                <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                                <h4><i class="icon fa fa-check"></i> Success!</h4>
                                {{Session::get('settings.save')}}
                                </div>
                            @endif
                            {{ csrf_field() }}
                            @foreach($settings as $key => $value)
                                <div class="form-group">
                                    <label for="">{{$value['description']}}</label>
                                    <textarea name="{{$key}}" rows="3" cols="40" placeholder="Put your ads code here." class="form-control">{{$value['value']}}</textarea>
                                </div>
                            @endforeach
                        </div>
                        <div class="box-footer">
                            <button class="btn btn-primary" type="submit">Save Settings</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        </section>
    </div>
@endsection
