@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box">
                        <div class="box-body">
                            @if($request->closed_by)
                                <div class="form-group">
                                    <p>
                                        <label for="">This request is closed.</label> by: {{$request->closedBy->username}}
                                    </p>
                                </div>
                            @endif
                            <label for="">Images to remove:</label>
                            <div style="margin-bottom: 10px;">
                                {{ $request->images }}
                            </div>
                            <label for="">Message:</label>
                            <div>
                                {{ $request->message }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <form role="form" id="closeForm" method="post">
                                    @if($request->closed_by)
                                        <div class="form-group">
                                            <p>
                                                <label for="">Closed By:</label> {{$request->closedBy->username}}
                                            </p>
                                        </div>
                                    @endif

                                    <div class="form-group">
                                        <p>
                                            <label for="">Sent By:</label> {{$request->email}}
                                        </p>
                                    </div>
                                    <div class="form-group">
                                        <p>
                                            <label for="">Reference Id:</label> {{$request->reference}}
                                        </p>
                                    </div>
                                    <div class="form-group">
                                        <label for="">What you did:</label>
                                        <textarea name="action" class="form-control" placeholder="Write here what you did, for later reference.">@if($request->action){{$request->action}}@endif</textarea>
                                    </div>
                                    {{ csrf_field() }}
                                    <input type="hidden" value="{{ $request->id }}" id="id" name="id">
                                    @if($request->closed_by)
                                        <button id="closeBtn" class="btn btn-danger btn-sm pull-right" type="submit">Update</button>
                                        <input type="hidden" name="method" value="update">
                                    @else
                                        <button id="closeBtn" class="btn btn-danger btn-sm pull-right" type="submit">Close</button>
                                        <input type="hidden" name="method" value="close">
                                    @endif
                                </form>
                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')

    <script type="text/javascript">
        $(document).ready(function() {
            $('#closeBtn').on("click", function(event){
                event.preventDefault();
                $("#closeForm").attr('action', "{{ route('admin.requests.close') }}").submit();
            });
        });
    </script>

@endsection
