@extends('layouts.admin')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                  <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Latests Closed Requests</h3>
                    </div>

                    {{-- @include('admin.tags.message') --}}
                    <!-- /.box-header -->
                    <div class="box-body">
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Reference Id</th>
                                    <th>From</th>
                                    <th>Images</th>
                                    <th>Message</th>
                                    <th>Action Taken</th>
                                    <th>Closed By</th>
                                    <th>Time Closed</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($requests as $request)
                                <tr>
                                    <td style="width: 150px;"><a href="{{route('admin.requests.show.closed', $request->id)}}">{{$request->reference}}</a></td>
                                    <td style="width: 50px;">{{$request->email}}</td>
                                    <td style="width: 350px;">{{$request->images}}</td>
                                    <td style="width: 350px;">
                                        {{ str_limit($request->message, $limit = 100, $end = '...') }}
                                    </td>
                                    <td style="width: 200px;">{{$request->action}}</td>
                                    <td style="width: 150px;">{{$request->closedBy->username}}</td>
                                    <td style="width: 250px;">{{$request->deleted_at}}</td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Reference Id</th>
                                    <th>From</th>
                                    <th>Images</th>
                                    <th>Message</th>
                                    <th>Action Taken</th>
                                    <th>Closed By</th>
                                    <th>Time Closed</th>
                                </tr>
                            </tfoot>
                        </table>
                        {{ $requests->links() }}
                    </div>
                    <!-- /.box-body -->
                  </div>
            </div>
        </section>
    </div>
@endsection
