@extends('layouts.admin')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                  <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Report Options</h3>
                        <div class="box-tools">
                            <a href="{{ route('admin.reports.editor.create')}}"><button class="btn btn-block btn-primary" type="submit" value="Add New"><i class="fa fa-fw fa-plus"></i> Add New</button></a>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        @include('admin.reports.editor.message')
                        <table id="example2" class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Description</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($options as $option)
                                <tr>
                                    <td style="width: 100px;"><a href="{{route('admin.reports.editor.edit', ['id' => $option->id])}}">{{$option->name}}</a></td>
                                    {{-- <td>{!!$post->body!!}</td> --}}
                                    <td style="width: 150px;">{{$option->description}}</td>
                                    <td style="width: 50px;">
                                        <form role="form" id="deleteForm-{{ $option->id }}" method="post">
                                            <input type="hidden" value="{{ $option->id }}" id="id" name="id">
                                            {{ csrf_field() }}
                                            <button id="deleteBtn-{{ $option->id }}" class="btn btn-xs btn-danger" type="submit"><i class="fa fa-trash"></i> Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Name</th>
                                    <th>Description</th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                    <!-- /.box-body -->
                  </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $('[id^=deleteBtn-]').on("click", function(event){
            event.preventDefault();
            var id = event.target.id.slice(10);
            swal({
                title: 'Wait!',
                text: "Are you sure you want to delete this option?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Delete',
                allowOutsideClick: false,
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger'
            }).then(function() {
                $("#deleteForm-"+id).attr('action', "{{ route('admin.reports.editor.delete')}}").submit();
            })
        });
    });
</script>
@endsection
