@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit Report Option</h3>
                        </div>
                        <form role="form" id="reportOptionForm" method="post">
                            <div class="box-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <label for="name">Name</label>
                                    <input type="text" placeholder="Enter report name." id="name" name="name" class="form-control" value="{{$report->name}}">
                                    <div id="text_input_feedback"></div>
                                    <input type="hidden" name="id" value="{{$report->id}}">
                                </div>
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea class="form-control" id="description" placeholder="Enter short description. This will be seen by site's users when they choose to report an album or a comment." name="description">{{$report->description}}</textarea>
                                    <div id="textarea_feedback"></div>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <button id="updateBtn" class="btn btn-primary pull-right" type="submit">Update</button>
                            </div>

                            <div class="box-footer">

                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {

        var name_max = 35;
        $('#text_input_feedback').html(name_max +' char left');

        // $('input#name').on('keyup',function(){
        //    var charCount = $(this).val().replace(/\s/g, '').length;
        // 	$("#text_input_feedback").text(charCount + " chars");
        // });


        $("#name").on("keyup keydown",function() {countNameCharacters();});
        $('#name').on('paste cut change', function () {
          setTimeout(function () {
            countNameCharacters();
          }, 100);
        });

        countNameCharacters();

        function countNameCharacters(){
            var text_length = $('#name').val().length;
            var text_remaining = name_max - text_length;

            $('#text_input_feedback').html(text_remaining + ' char left');
        }


        var description_max = 250;
        $('#textarea_feedback').html(description_max +' char left');

        $("#description").on("keyup keydown",function() {countDescriptionCharacters();});
        $('#description').on('paste cut change', function () {
          setTimeout(function () {
            countDescriptionCharacters();
          }, 100);
        });

        countDescriptionCharacters();

        function countDescriptionCharacters(){
            var text_length = $('#description').val().length;
            var text_remaining = description_max - text_length;

            $('#textarea_feedback').html(text_remaining + ' char left');
        }

        $("#updateBtn").on("click", function(e){
            e.preventDefault();
            $('#reportOptionForm').attr('action', "{{ route('admin.reports.editor.update')}}").submit();
        });
    });
</script>

@endsection
