@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box">
                        <div class="box-body">
                            <h2>{{$album->title}}</h2>

                            @if($album->creator != null)
                            <span>by
                                <a href="{{url('user')}}/{{$album->creator->username }}">{{$album->creator->username}}</a>
                            </span>
                            @endif
                            <span title="{{$album->created_at}}">{{$album->createdAt()}}</span>
                            <br><br>

                            @foreach ($album->images as $image)
                                <div class="image">
                                    <img src="{{ url($image->hash) }}.{{ $image->extension }}" class="img-responsive center-block">
                                </div>
                                <div>
                                    {{ $image->title }}
                                </div>

                                <div>
                                    {{ $image->description }}
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <form role="form" id="makeItSoForm" method="post">
                                    <div class="form-group">
                                        <p>
                                            <label for="">Created By: <a href="{{url('user')}}/{{$album->creator->username}}">{{$album->creator->username}}</a></label>
                                            <input type="hidden" name="user" value="{{$album->creator->id}}">
                                            <input type="hidden" name="reportable_id" value="{{$album->id}}">
                                            <input type="hidden" name="action" value="album">
                                        </p>
                                        <p><label for="">Report reason:</label> {{$report[0]->reason}}</p>
                                        <input type="hidden" name="id" value="{{$report[0]->id}}">
                                        <input type="hidden" name="reason" value="{{$report[0]->reason}}">
                                        <p><label for="">Reported by:</label> {{$report[0]->total_reports}} user(s)</p>
                                    </div>
                                    <div class="form-group">
                                        <label for="">With the User:</label>
                                        <div class="radio">
                                            <label title="Leave it as it is.">
                                              <input type="radio" checked="true" value="nothing" id="withUserRadios1" name="withUser">
                                              Do nothing
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="User will be banned.">
                                              <input type="radio" value="ban" id="withUserRadios2" name="withUser">
                                              Ban user
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="User will be deleted and all associted albums and comments as well.">
                                              <input type="radio" value="delete" id="withUserRadios3" name="withUser">
                                              Delete user
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="">With the Album:</label>
                                        <div class="radio">
                                            <label title="Leave it as it is.">
                                              <input type="radio" checked="true" value="nothing" id="withAlbumRadios1" name="withAlbum">
                                              Do nothing
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="Album and all comments will be deleted.">
                                              <input type="radio" value="delete" id="withAlbumRadios2" name="withAlbum">
                                              Delete Album
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="User will not be able to publish this again.">
                                              <input type="radio" value="unpublish" id="withAlbumRadios3" name="withAlbum">
                                              Unpublish Album
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="Set to mature, will remain published.">
                                              <input type="radio" value="mature" id="withAlbumRadios4" name="withAlbum">
                                              Set as Mature
                                            </label>
                                        </div>
                                    </div>
                                    {{ csrf_field() }}
                                    {{-- <input type="hidden" value="{{ $report->id }}" id="id" name="id" class="form-control"> --}}
                                    <button id="makeItSoBtn" class="btn btn-danger btn-sm pull-right" title="This will close the report!" type="submit">Make it so!</button>
                                </form>
                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')

    <script type="text/javascript">
        $(document).ready(function() {
            $('#makeItSoBtn').on("click", function(event){
                event.preventDefault();
                var id = event.target.id.slice(10);
                swal({
                    title: 'Wait!',
                    text: "Are you sure?",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Make It So',
                    allowOutsideClick: false,
                    confirmButtonClass: 'btn btn-success',
                    cancelButtonClass: 'btn btn-danger'
                }).then(function() {
                    $("#makeItSoForm").attr('action', "{{ route('admin.reports.album.makeitso')}}").submit();
                })
            });
        });
    </script>

@endsection
