@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Edit Page</h3>
                        </div>
                        <form role="form" id="pageForm" method="post">
                            <div class="box-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <input type="hidden" name="id" value="{{$page->id}}">
                                    <label for="name">Name</label>
                                    <input type="text" placeholder="Enter page name" id="name" name="name" class="form-control" value="{{$page->name}}">
                                </div>
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <input type="hidden" name="id" value="{{$page->id}}">
                                    <label for="template">Page Template</label>
                                    <input type="text" placeholder="Enter page template" id="template" name="template" class="form-control" value="{{$page->template}}">
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Content</label>
                                    <textarea id="content" name="content">{{$page->content}}</textarea>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <button id="saveBtn" class="btn btn-default btn-sm" type="submit">Save</button>
                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('scripts')

<!-- CK Editor -->
{{-- <script src="https://cdn.ckeditor.com/4.5.7/standard/ckeditor.js"></script> --}}
<script src="http://cdn.ckeditor.com/4.5.11/standard-all/ckeditor.js"></script>
<script>
    var config = {
        extraPlugins: 'image2',
        height: 500,
        allowedContent: true
    };

    CKEDITOR.replace( 'content', config );
</script>

<script type="text/javascript">
    $(document).ready(function() {
        $("#saveBtn").on("click", function(e){
            e.preventDefault();
            $('#pageForm').attr('action', "{{route('admin.pages.save')}}").submit();
        });
    });
</script>

@endsection
