
@extends('layouts.admin')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-4">
                  <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Reorder Pages</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        @if (Session::has('page.order'))
                            <div class="alert alert-success alert-dismissible">
                            <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('page.order')}}
                            </div>
                        @endif
                        <div class="pages">
                            <ul id="pages" class="pages-list">
                                @foreach ($pages as $page)
                                    <li id="{{$page->id}}">
                                        {{$page->name}}
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                        <button id="saveBtn" class="btn btn-primary" type="submit">Save Order</button>
                    </div>
                    <!-- /.box-body -->
                  </div>
            </div>
        </section>
    </div>

<script type="text/javascript">


        Sortable.create(pages, { /* options */ });

        $("#saveBtn").click(function( e ){
            e.preventDefault();

            var pagesOrder = [];
            $("#pages li").each(function() {
                  pagesOrder.push($(this).attr('id'));
            });
            console.log('ids: ' + JSON.stringify(pagesOrder));
            $.ajax({
                type: "POST",
                url: "{{route('admin.pages.order.save')}}",
                data: {
                    ids: pagesOrder,
                    _token: Laravel.csrfToken
                },
                success: function(response)
                {
                    location.reload();
                }
            });
        });
</script>
@endsection
