@extends('layouts.admin')

@section('content')
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-xs-12">
                  <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Pages</h3>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body">
                        @if (Session::has('page.saved'))
                            <div class="alert alert-success alert-dismissible">
                            <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('page.saved')}}
                            </div>
                        @endif
                        <table class="table table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pages as $page)
                                <tr>
                                    <td style="width: 400px;"><a href="/admin/pages/show/{{$page->id}}">{{$page->name}}</a></td>
                                    <td style="width: 50px;">
                                        @if($page->active) <span class="label label-success">Active</span> @else <span class="label label-warning">Not Active</span> @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr>
                                    <th>Title</th>
                                    <th>Status</th>
                                </tr>
                            </tfoot>
                        </table>

                    </div>
                    <!-- /.box-body -->
                  </div>
            </div>
        </section>
    </div>
@endsection
