@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Main content -->
        <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Memes</h3>
                        <div class="box-tools">
                            <a href="{{ route('admin.meme.create')}}"><button class="btn btn-block btn-primary" type="submit" value="Add New"><i class="fa fa-fw fa-plus"></i> Add New</button></a>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="text-center">
                        {{$memes->links()}}
                        </div>
                        @if (Session::has('savememe'))
                            <div class="alert alert-success alert-dismissible">
                            <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('savememe')}}
                            </div>
                        @endif
                        @foreach ($memes as $meme)
                            <div class="memebox">
                                <a href="{{route('admin.meme.show', $meme->id)}}" >
                                    <img  src="{{url('memes/thumb/' . $meme->slug .'.'.$meme->extension)}}">
                                    <div class="title-container">
                                        <h3>{{$meme->title}}</h3>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                        <div class="text-center">
                        {{$memes->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
    </div>
@endsection
