@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Add New Meme</h3>
                        </div>
                        <form role="form" id="memeForm" method="post" enctype="multipart/form-data">
                            <div class="box-body">
                                @if (count($errors) > 0)
                                    <div class="alert alert-danger">
                                        <ul>
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                                <div class="form-group">
                                    {{ csrf_field() }}
                                    <label for="exampleInputEmail1">Title</label>
                                    <input type="text" placeholder="Enter meme title" id="title" name="title" value="{{old('title')}}" class="form-control">
                                </div>
                                <div class="form-group">
                                    <input type="file" name="file" id="file" class="inputfile" data-multiple-caption="{count} files selected"/>
                                    <label for="file"><span>Choose an Image&hellip;</span></label>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <button id="saveBtn" class="btn btn-primary" type="submit">Save</button>
                            </div>

                            <div class="box-footer">

                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection


@section('scripts')
<script type="text/javascript">
    $(document).ready(function() {
        $("#saveBtn").on("click", function(e){
            e.preventDefault();
            $('#memeForm').attr('action', '{{route('admin.meme.save')}}').submit();
        });
    });
</script>

<script src="{{asset('js/custom-file-input.js')}}"></script>

@endsection
