@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box">
                        <div class="box-body">
                            <h2>{{$image->title}}</h2>

                            @if($image->creator != null)
                            <span>by
                                <a href="{{url('user')}}/{{$image->creator->username }}">{{$image->creator->username}}</a>
                            </span>
                            @endif
                            <span title="{{$image->created_at}}">{{$image->createdAt()}}</span>
                            <br><br>

                            <div class="image">
                                <img src="{{ url($image->hash) }}.{{ $image->extension }}" class="img-responsive center-block">
                            </div>

                            <div>
                                {{ $image->description }}
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <form role="form" id="makeItSoForm" method="post">
                                    @if($image->creator != null)
                                        <div class="form-group">
                                            <p>
                                                <label for="">Created By: <a href="{{url('user')}}/{{$image->creator->username}}">{{$image->creator->username}}</a></label>
                                                <input type="hidden" name="user" value="{{$image->creator->id}}">
                                            </p>
                                        </div>
                                        <div class="form-group">
                                            <label for="">With the User:</label>
                                            <div class="radio">
                                                <label title="Leave it as it is.">
                                                  <input type="radio" checked="true" value="nothing" id="withUserRadios1" name="withUser">
                                                  Do nothing
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label title="User will be banned.">
                                                  <input type="radio" value="ban" id="withUserRadios2" name="withUser">
                                                  Ban user
                                                </label>
                                            </div>
                                            <div class="radio">
                                                <label title="User will be deleted and all associted albums and comments as well.">
                                                  <input type="radio" value="delete" id="withUserRadios3" name="withUser">
                                                  Delete user
                                                </label>
                                            </div>
                                        </div>
                                    @endif
                                    <div class="form-group">
                                        <input type="hidden" name="id" value="{{$image->id}}">
                                        <label for="">With the Image:</label>
                                        <div class="radio">
                                            <label title="Leave it as it is.">
                                              <input type="radio" checked="true" value="nothing" id="withAlbumRadios1" name="withImage">
                                              Do nothing
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="Image will be deleted.">
                                              <input type="radio" value="delete" id="withAlbumRadios2" name="withImage">
                                              Delete Image
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Reason:</label>
                                        <textarea name="reason" class="form-control" placeholder="Give reason for this action, so you know why you did it."></textarea>
                                    </div>
                                    {{ csrf_field() }}
                                    <button id="makeItSoBtn" class="btn btn-danger btn-sm pull-right" type="submit">Make it so!</button>
                                </form>
                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')

<script type="text/javascript">
    $(document).ready(function() {

        $('#makeItSoBtn').on("click", function(event){
            event.preventDefault();
            swal({
                title: 'Wait!',
                text: "Are you sure you want to perform this action?",
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Make It So',
                allowOutsideClick: false,
                confirmButtonClass: 'btn btn-success',
                cancelButtonClass: 'btn btn-danger'
            }).then(function() {
                $("#makeItSoForm").attr('action', "{{ route('admin.image.makeitso')}}").submit();
            })
        });

    });
</script>

@endsection
