@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Latests Images</h3>
                    </div>
                    <div class="box-body">
                        <div class="text-center">
                        {{$images->links()}}
                        </div>
                        @if (Session::has('makeitso'))
                            <div class="alert alert-success alert-dismissible">
                            <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('makeitso')}}
                            </div>
                        @endif
                        @foreach ($images as $image)
                            <div class="col-md-55">
                                <a href="/admin/images/show/{{$image->id}}" >
                                    <img  src="{{url($image->path)}}/thumb/{{$image->hash }}.{{$image->extension }}">
                                </a>
                            </div>
                        @endforeach
                        <div class="text-center">
                        {{$images->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
    </div>
@endsection
