@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-9">
                    <div class="box">
                        <div class="box-body">
                            @if($comment->creator != null)
                            <span>by
                                <a href="{{url('user')}}/{{$comment->creator->username }}">{{$comment->creator->username}}</a>
                            </span>
                            @endif
                            <span title="{{$comment->created_at}}">{{$comment->createdAt()}}</span>
                            <br><br>

                            <div>
                                {{ $comment->body }}
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title">Options</h3>
                        </div>
                            <div class="box-body">
                                <form role="form" id="makeItSoForm" method="post">
                                    <div class="form-group">
                                        <p>
                                            <label for="">Created By: <a href="{{url('user')}}/{{$comment->creator->username}}">{{$comment->creator->username}}</a></label>
                                            <input type="hidden" name="user" value="{{$comment->creator->id}}">
                                            <input type="hidden" name="id" value="{{$comment->id}}">
                                        </p>
                                    </div>
                                    <div class="form-group">
                                        <label for="">With the User:</label>
                                        <div class="radio">
                                            <label title="Leave it as it is.">
                                              <input type="radio" checked="true" value="nothing" id="withUserRadios1" name="withUser">
                                              Do nothing
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="User will be banned. Nothing will be deleted. User will not be able to login.">
                                              <input type="radio" value="ban" id="withUserRadios2" name="withUser">
                                              Ban user
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="User will be deleted and all associted albums, images and comments as well.">
                                              <input type="radio" value="delete" id="withUserRadios3" name="withUser">
                                              Delete user
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="">With the Comment:</label>
                                        <div class="radio">
                                            <label title="Leave it as it is.">
                                              <input type="radio" checked="true" value="nothing" id="withCommentRadios1" name="withComment">
                                              Do nothing
                                            </label>
                                        </div>
                                        <div class="radio">
                                            <label title="Comment will be deleted.">
                                              <input type="radio" value="delete" id="withCommentRadios2" name="withComment">
                                              Delete Comment
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="">Reason:</label>
                                        <textarea name="reason" class="form-control" placeholder="Give reason for this action, so you know why you did it."></textarea>
                                    </div>
                                    {{ csrf_field() }}
                                    {{-- <input type="hidden" value="{{ $report->id }}" id="id" name="id" class="form-control"> --}}
                                    <button id="makeItSoBtn" class="btn btn-danger btn-sm pull-right" title="This will close the report!" type="submit">Make it so!</button>
                                </form>
                            </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection

@section('scripts')

    <script type="text/javascript">
        $(document).ready(function() {
            $('#makeItSoBtn').on("click", function(event){
                event.preventDefault();
                var id = event.target.id.slice(10);
                swal({
                    title: 'Wait!',
                    text: "Are you sure you want to perform this action?",
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Make It So',
                    allowOutsideClick: false,
                    confirmButtonClass: 'btn btn-success',
                    cancelButtonClass: 'btn btn-danger'
                }).then(function() {
                    $("#makeItSoForm").attr('action', "{{ route('admin.comments.makeitso')}}").submit();
                })
            });
        });
    </script>

@endsection
