@extends('layouts.admin')

@section('content')

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">

        <!-- Main content -->
        <section class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header">
                        <h3 class="box-title">Latests Albums</h3>
                    </div>
                    <div class="box-body">
                        <div class="text-center">
                        {{$albums->links()}}
                        </div>
                        @if (Session::has('makeitso'))
                            <div class="alert alert-success alert-dismissible">
                            <button aria-hidden="true" data-dismiss="alert" class="close" type="button">×</button>
                            <h4><i class="icon fa fa-check"></i> Success!</h4>
                            {{Session::get('makeitso')}}
                            </div>
                        @endif
                        @foreach ($albums as $album)
                            <div class="col-md-55">
                                <a href="/admin/albums/show/{{$album->id}}" >
                                    @if($album->images->pluck('hash')->first())
                                        {{-- <img  src="{{url('thumb')}}/{{$album->images->pluck('hash')->first() }}.{{$album->images->pluck('extension')->first()}}"> --}}
                                        <img  src="{{url($album->images->pluck('path')->first())}}/thumb/{{$album->images->pluck('hash')->first() }}.{{$album->images->pluck('extension')->first()}}">
                                    @else
                                        <img  src="{{url('images/default.png')}}">
                                    @endif
                                </a>
                            </div>
                        @endforeach
                        <div class="text-center">
                        {{$albums->links()}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </section>
    </div>
@endsection
