Dropzone.options.myAwesomeDropzone = {

    // Dropzone configuration
    autoProcessQueue: false,
    addRemoveLinks: true,
    uploadMultiple: true,
    parallelUploads: 100,
    maxFiles: 100,
    previewsContainer: '#dropzone-previews',
    // clickable:'#dropzone-previews',
    acceptedFiles: ".jpeg,.jpg,.png,.gif",
    maxFilesize: 5,

    // The setting up of the dropzone
    init: function() {
    var myDropzone = this;

    // First change the button to actually tell Dropzone to process the queue.
    $("#sbmtbtn").on('click',function(e) {
      // Make sure that the form isn't actually being sent.
          e.preventDefault();
          e.stopPropagation();
          myDropzone.processQueue();
        });

      // Listen to the sendingmultiple event. In this case, it's the sendingmultiple event instead
      // of the sending event because uploadMultiple is set to true.
      this.on("sendingmultiple", function() {
      // Gets triggered when the form is actually being sent.
      // Hide the success button or the complete form.
      });
      this.on("successmultiple", function(files, response) {
      // Gets triggered when the files have successfully been sent.
      // Redirect user or notify of success.
      window.location.href='/album/' + response;
      //alert(response);
      });
      this.on("errormultiple", function(files, response) {
      // alert('error');
      // Gets triggered when there was an error sending the files.
      // Maybe show form again, and notify user of error
      });
    }
}
