<?php

use Illuminate\Database\Seeder;

class VoteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // factory(App\Vote::class, 1000)->create()->each(function($vote){
        // 	$vote->save();
        // });

        $faker = Faker\Factory::create();

        $count = 1000;
        for($i = 0; $i < $count; $i++) {
            try {
                App\Models\Vote::create([
                    'user_id' => $faker->numberBetween(1, 50),
                    'votable_id' => $faker->numberBetween(1, (int)env('APP_ALBUMS', 100)),
                    'votable_type' => 'App\Models\Album',
                    'status' => 'upvote',
                ]);
            }catch(\Illuminate\Database\QueryException $e) {
                // echo "double App\Models\Album, ";
            }
        }

        $count = 5000;
        for($i = 0; $i < $count; $i++) {
            try {
                App\Models\Vote::create([
                    'user_id' => $faker->numberBetween(1, 50),
                    'votable_id' => $faker->numberBetween(1, (int)env('APP_COMMENTS', 2500)),
                    'votable_type' => 'App\Models\Comment',
                    'status' => 'upvote',
                ]);
            }catch(\Illuminate\Database\QueryException $e) {
                // echo "double App\Models\Comment, ";
            }
        }


    }
}
