<?php

use Illuminate\Database\Seeder;
use App\Models\Setting;

class UpdateSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $version = Setting::where('name', 'version')->first();
        $currentVersion = (int)str_replace(".","", $version->body);

        if($currentVersion < 101)
        {
            $this->call(SettingSeeder::class);
            $this->call(PageSeeder::class);
            $this->call(ReportOptionsSeeder::class);
            $this->call(TagSeeder::class);
        }

        if($currentVersion < 102)
        {
            $this->call(UpdateSeeder_102::class);
        }

    }
}
