<?php

use Illuminate\Database\Seeder;


class SettingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        App\Models\Setting::create([
            'name' => 'website_name',
            'description' => 'Your Website Name',
            'body' => env('APP_NAME', 'ImgShare'),
        ]);

        App\Models\Setting::create([
            'name' => 'website_email',
            'description' => 'Your Contact Address. Used for Contact Form.',
            'body' => env('APP_EMAIL', 'contact@gmail.com'),
        ]);

        App\Models\Setting::create([
            'name' => 'website_title',
            'description' => 'Your Website Title',
            'body' => 'ImageShare.io Most beautiful images on internet.',
        ]);

        App\Models\Setting::create([
            'name' => 'website_description',
            'description' => 'Your Website Description',
            'body' => 'Submit your favorite images and share with friends.',
        ]);

        App\Models\Setting::create([
            'name' => 'website_keywords',
            'description' => 'Your Website Keywords',
            'body' => 'images, image sharing, photo, my pictures',
        ]);

        App\Models\Setting::create([
            'name' => 'analytics',
            'description' => 'Google Analytics Code',
            'body' => "",
        ]);

        App\Models\Setting::create([
            'name' => 'social',
            'description' => 'Social Buttons Code',
            'body' => '//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-57e12b521e0c1ff7',
        ]);

        App\Models\Setting::create([
            'name' => 'ad_unit_top',
            'description' => 'Ad Unit Above Album/Image',
            'body' => '<img class="img-responsive center-block" src="http://imageshare.code4fun.io/ad_top.png" />',
        ]);

        App\Models\Setting::create([
            'name' => 'ad_unit_right_1',
            'description' => 'Ad Unit Right Sidebar Position 1',
            'body' => '<img class="img-responsive center-block" src="http://imageshare.code4fun.io/ad_sidebar_1.png" />',
        ]);

        App\Models\Setting::create([
            'name' => 'ad_unit_right_2',
            'description' => 'Ad Unit Right Sidebar Position 2',
            'body' => '<img class="img-responsive center-block" src="http://imageshare.code4fun.io/ad_sidebar_2.png" />',
        ]);

        App\Models\Setting::create([
            'name' => 'ad_unit_comments_top',
            'description' => 'Ad Unit Above Comments',
            'body' => '<img class="img-responsive center-block" src="http://imageshare.code4fun.io/ad_top.png" />',
        ]);

        App\Models\Setting::create([
            'name' => 'enable_seo_for_published_albums',
            'description' => 'This will enable Seo Links for Published Albums',
            'body' => 'yes',
        ]);

        App\Models\Setting::create([
            'name' => 'sitemap_cache',
            'description' => 'How long should sitemap be cached. In minutes.',
            'body' => '10',
        ]);

        App\Models\Setting::create([
            'name' => 'pagination',
            'description' => 'Pagination for frontpage. Infinite scroll or links.',
            'body' => 'links',
        ]);

        App\Models\Setting::create([
            'name' => 'approve_albums_before_publish',
            'description' => 'App\Modelsrove albums before they are published.',
            'body' => 'disabled',
        ]);

        App\Models\Setting::create([
            'name' => 'video_to_gif',
            'description' => 'Turn on Video to Gif feature.',
            'body' => 'enabled',
        ]);

        App\Models\Setting::create([
            'name' => 'meme',
            'description' => 'Turn on Meme Generation feature.',
            'body' => 'enabled',
        ]);

        App\Models\Setting::create([
            'name' => 'max_upload_file_size',
            'description' => 'Max upload file size.',
            'body' => '5',
        ]);

        App\Models\Setting::create([
            'name' => 'max_upload_files',
            'description' => 'Max upload files at once.',
            'body' => '50',
        ]);

        App\Models\Setting::create([
            'name' => 'version',
            'description' => 'Version',
            'body' => '1.0.2',
        ]);
    }
}
