<?php

use Illuminate\Database\Seeder;

class ReportSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker\Factory::create();

        for($i = 0; $i < 20; $i++) {
            try {
                $reason = App\Models\ReportOptions::where('id', $faker->numberBetween(1, 5))->first();
                App\Models\Report::create([
                    'reported_by' => $faker->numberBetween(1, 50),
                    'reportable_id' => $faker->numberBetween(1, (int)env('APP_ALBUMS', 100)),
                    'reportable_type' => 'App\Models\Album',
                    'reason' => $reason->name,
                ]);
            }catch(\Illuminate\Database\QueryException $e) {
                // echo "double";
            }
        }

        for($i = 0; $i < 40; $i++) {
            try {
                $reason = App\Models\ReportOptions::where('id', $faker->numberBetween(1, 5))->first();
                App\Models\Report::create([
                    'reported_by' => $faker->numberBetween(1, 50),
                    'reportable_id' => $faker->numberBetween(1, 100),
                    'reportable_type' => 'App\Models\Comment',
                    'reason' => $reason->name,
                ]);
            }catch(\Illuminate\Database\QueryException $e) {
                // echo "double";
            }
        }
    }
}
