<?php

use Illuminate\Database\Seeder;

class RemovalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $faker = Faker\Factory::create();
        for ($i=0; $i < 15; $i++) {

            $images = "";
            for ($j=0; $j < $faker->numberBetween(1, 8); $j++) {
                $image = App\Models\Image::where('id', $faker->numberBetween(1, env('APP_IMAGES', 15)))->first();
                $images .= $image->hash . ', ';
            }

            $images = rtrim($images, ", ");

            $username = str_replace(".","",$faker->unique()->username);
            App\Models\RemovalRequest::create([
                'email' => $username.'@gmail.com',
                'message' => $faker->paragraph(10),
                'reference' => str_random(7),
                'images' => $images,
            ]);
        }

    }
}
