<?php

use Illuminate\Database\Seeder;
use Carbon\Carbon;

class ImageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if(!is_dir('public/test/')) {
            factory(App\Models\Image::class, 100)->create()->each(function($image){
             $image->save();
            });
        } else {
            $faker = Faker\Factory::create();
            $images = glob("public/test/{*.jpg,*.gif,*.png}", GLOB_BRACE);
            $dev = env('APP_DEVELOPMENT', false);
            $count = 0;

            foreach($images as $image){
                if($dev){
                    if($count > (int)env('APP_IMAGES', 450))
                        break;
                }
                $count += 1;

                $hash = str_random(7);
                $thumbnailName = $hash . '.jpg';
                // echo $thumbnailName . " - ";
                $thumbnailImage = ImgResizer::make($image)->fit(180, 180);

                $current = Carbon::now();
                $year = $current->year;
                $month = $current->month;
                $day = $current->day;
                $hour = $current->hour;
                $folder = 'uploads/'.$year.'/'.$month.'/'.$day.'/'.$hour;

                if( ! file_exists('public/'.$folder)) {
                    // echo "-create folder: ".$folder;
                    $oldmask = umask(0);
                    mkdir('public/'.$folder, 0775, true);
                    mkdir('public/'.$folder . '/thumb/', 0775, true);
                    umask($oldmask);
                }
                copy($image, 'public/'.$folder.'/'.$hash.'.jpg');
                $thumbnailImage->save( 'public/'.$folder . '/thumb/'. $thumbnailName);

                $album = App\Models\Album::where('id', $faker->numberBetween(1, (int)env('APP_ALBUMS', 100)))->first();
                $album_id = $album->id;
                $user_id = $album->creator->id;
                $album->published = true;
                $album->published_at = Carbon::now();
                $album->views = $faker->numberBetween(100, 500);
                $album->privacy = false;
                $album->save();
                $order = $album->images->count()+1;

                App\Models\Image::create([
                    'hash' => $hash,
                    'extension' => 'jpg',
                    'user_id' => $user_id,
                    'album_id' => $album_id,
                    'title' => $faker->sentence($faker->numberBetween(2, 6)),
                    'description' => $faker->paragraph($faker->numberBetween(2, 3)),
                    'order' => $order,
                    'path' => $folder,
                    'views' => $faker->numberBetween(100, 500),
                    'privacy' => false,
                ]);
            }
        }
    }
}
