<?php

use Illuminate\Database\Seeder;

class FavoriteSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // factory(App\Favorite::class, 200)->create()->each(function($favorite){
        // 	$favorite->save();
        // });

        $faker = Faker\Factory::create();
        $dev = env('APP_DEVELOPMENT', false);
        $favs = 0;
        if($dev){
            $favs = 10;
        } else {
            $favs = 400;
        }
        for($i = 0; $i < $favs; $i++) {
            try {
                App\Models\Favorite::create([
                    'user_id' => $faker->numberBetween(1, 50),
                    'album_id' => $faker->numberBetween(1, env('APP_ALBUMS', 100))
                ]);
            }catch(\Illuminate\Database\QueryException $e) {
                // echo "double";
            }
        }
    }
}
