<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $tmp = glob("public/tmp/{*.jpg,*.gif,*.png}", GLOB_BRACE);
        foreach($tmp as $image){
             @unlink($image);
        }

        //File::deleteDirectory('public/uploads/2016');

        DB::statement('SET FOREIGN_KEY_CHECKS=0');

        DB::table('users')->truncate();
        DB::table('albums')->truncate();
        DB::table('images')->truncate();
        DB::table('comments')->truncate();
        DB::table('favorites')->truncate();
        DB::table('votes')->truncate();
        DB::table('tags')->truncate();
        DB::table('album_tag')->truncate();
        DB::table('report_options')->truncate();
        DB::table('reports')->truncate();
        DB::table('settings')->truncate();
        DB::table('pages')->truncate();
        DB::table('requests')->truncate();

        DB::statement('SET FOREIGN_KEY_CHECKS=1');

        $this->call(UserSeeder::class);

        $this->call(SettingSeeder::class);
        $this->call(PageSeeder::class);
        $this->call(LaratrustSeeder::class);
        $this->call(ReportOptionsSeeder::class);
        $this->call(TagSeeder::class);

        $this->call(AlbumSeeder::class);
        $this->call(ImageSeeder::class);
        $this->call(CommentSeeder::class);
        $this->call(FavoriteSeeder::class);
        $this->call(VoteSeeder::class);
        $this->call(ReportSeeder::class);
        $this->call(RemovalSeeder::class);
    }
}
