<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateReportsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('reports', function (Blueprint $table) {
            $table->bigincrements('id');
            $table->biginteger('reportable_id')->unsigned()->index();
            $table->string('reportable_type');
            $table->biginteger('reported_by')->unsigned()->index();
            $table->biginteger('resolved_by')->unsigned()->index();
            $table->string('reason');
            $table->string('actions')->nullable();
            $table->softDeletes();
            $table->timestamps();

            $table->unique(['reported_by', 'reportable_id', 'reportable_type']);
            $table->foreign('reported_by')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('reports');
    }
}
