<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateImagesTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('images', function (Blueprint $table) {
            $table->bigincrements('id');
            $table->string('title')->nullable();
            $table->text('description')->nullable();
            $column = $table->string('hash')->unique();
            $table->index('hash');
            $column->collation = 'utf8_bin';
            $table->string('slug')->unique()->nullable();
            $table->string('extension');
            $table->string('bucket')->nullable();
            $table->string('path')->nullable();
            $table->integer('size')->default(0);
            $table->integer('bandwidth')->default(0);
            $table->biginteger('user_id')->nullable()->unsigned();
            $table->biginteger('album_id')->unsigned();
            $table->biginteger('views')->unsigned()->default(0);
            $table->boolean('privacy')->default(true);
            $table->tinyInteger('order')->unsigned();
            $table->string('reason')->nullable()->comment('Reason why image was deleted.');
            $table->biginteger('deleted_by')->nullable()->unsigned();
            $table->softDeletes();
            $table->timestamps();


            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
            $table->foreign('album_id')->references('id')->on('albums')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('images');
    }
}
