<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateAlbumsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('albums', function (Blueprint $table) {
            $table->bigincrements('id');
            $table->string('title')->nullable();
            $table->string('slug')->unique()->nullable();
            $column = $table->string('hash')->unique();
            $table->index('hash');
            $column->collation = 'utf8_bin';
            $table->biginteger('user_id')->nullable()->unsigned();
            $table->boolean('published')->default(false);
            $table->boolean('approved')->nullable();
            $table->boolean('mature')->default(false);
            $table->biginteger('views')->unsigned()->default(0);
            $table->boolean('privacy')->default(true);
            $table->string('reason')->nullable()->comment('Reason why album was deleted/unpublished.');
            $table->dateTime('published_at')->nullable();
            $table->dateTime('unpublished_at')->nullable();
            $table->biginteger('unpublished_by')->nullable()->unsigned();
            $table->biginteger('deleted_by')->nullable()->unsigned();
            $table->softDeletes();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('albums');
    }
}
