<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigincrements('id');
            $table->string('username')->unique();
            $table->string('email')->unique();
            $table->string('password');
            $table->rememberToken();
            $table->boolean('activated')->default(true);
            $table->integer('points')->unsigned()->default(0);
            $table->dateTime('banned_at')->nullable();
            $table->dateTime('banned_til')->nullable();
            $table->biginteger('action_by')->nullable()->unsigned();
            $table->softDeletes();
            $table->string('reason')->nullable()->comment('Reason why user was banned/deleted.');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
