<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/
$count = 0;
$factory->define(App\Models\User::class, function (Faker\Generator $faker)
{
    $username = str_replace(".","",$faker->unique()->username);
    return [
        'username' => $username,
        'email' => $username.'@gmail.com',
        'password' => bcrypt('123456'),
        'remember_token' => str_random(10),
    ];
});

$factory->define(App\Models\Album::class, function (Faker\Generator $faker)
{
    return [
        'hash' => str_random(7),
        'title' => $faker->sentence,
        'user_id' => $faker->numberBetween(1, 50),
        'tag_id' => $faker->numberBetween(1, 9),
        'published' => false,
    ];
});

$factory->define(App\Models\Image::class, function (Faker\Generator $faker)
{
    try {
        $file = $faker->image($dir = public_path().'/tmp', $width = 800, $height = 600, '', true);
        $hash = str_random(7);
        $thumbnailName = $hash . '.jpg';
        echo $thumbnailName . " - ";
        $thumbnailImage = ImgResizer::make($file)->fit(180, 180);
        $thumbnailImage->save( public_path() . '/thumb/'. $thumbnailName);
        rename($file, 'public/'.$hash.'.jpg');

        $album = App\Models\Album::where('id', $faker->numberBetween(1, 50))->first();
        $album_id = $album->id;
        $user_id = $album->creator->id;
        $album->published = true;
        $album->published_at = Carbon::now();
        $album->views = $faker->numberBetween(100, 500);
        $album->privacy = false;
        $album->save();
        $order = 1;

        return [
            'hash' => $hash,
            'extension' => 'jpg',
            'user_id' => $user_id,
            'album_id' => $album_id,
            'title' => $faker->sentence($faker->numberBetween(2, 6)),
            'description' => $faker->paragraph($faker->numberBetween(2, 3)),
            'order' => $order,
            'views' => $faker->numberBetween(100, 500),
            'privacy' => false,
        ];
    } catch(Intervention\Image\Exception\NotReadableException $e) {
        @unlink($file);
        echo "Problem downloading image from lorempixel.com, skipping this image. ";
        $hash = str_random(7);
        return [
            'hash' => $hash,
            'extension' => 'jpg',
            'user_id' => 10,
            'album_id' => 50,
            'title' => $faker->sentence($faker->numberBetween(2, 6)),
            'description' => $faker->paragraph($faker->numberBetween(2, 3)),
            'order' => 1,
            'views' => 0,
        ];
    }

});

$factory->define(App\Models\Comment::class, function (Faker\Generator $faker)
{
    $album = App\Models\Album::where('id', $faker->numberBetween(1, (int)env('APP_ALBUMS', 100)))->first();
    $user = App\Models\User::where('id', $faker->numberBetween(1, 50))->first();
    return [
        'user_id' => $user->id,
        'album_id' => $album->id,
        'body' => $faker->paragraph,
    ];
});

// $factory->define(App\Models\Favorite::class, function (Faker\Generator $faker) {
//     return [
//         'user_id' => $faker->numberBetween(1, 50),
//         'album_id' => $faker->numberBetween(1, 100),
//     ];
// });

// $factory->define(App\Models\Vote::class, function (Faker\Generator $faker) {
//     return [
//         'user_id' => $faker->numberBetween(1, 50),
//         'votable_id' => $faker->numberBetween(1, 2000),
//         'votable_type' => 'App\Models\Comment',
//         'status' => 'upvote',
//     ];
// });
