<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Setting;
use App\Models\Page;
use View;
use Cache;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        if(!app()->runningInConsole() ){
            $setting = Cache::rememberForever('website_name', function() {
                return Setting::where('name', 'website_name')->first();
            });
            View::share('website_name', $setting->body);

            $setting = Cache::rememberForever('website_title', function() {
                return Setting::where('name', 'website_title')->first();
            });
            View::share('website_title', $setting->body);

            $setting = Cache::rememberForever('website_description_test', function() {
                return Setting::where('name', 'website_description')->first();
            });
            View::share('website_description', $setting->body);

            $setting = Cache::rememberForever('website_keywords', function() {
                return Setting::where('name', 'website_keywords')->first();
            });
            View::share('website_keywords', $setting->body);

            $setting = Cache::rememberForever('analytics', function() {
                return Setting::where('name', 'analytics')->first();
            });
            View::share('analytics', $setting->body);

            $setting = Cache::rememberForever('social', function() {
                return Setting::where('name', 'social')->first();
            });
            View::share('social', $setting->body);

            $setting = Cache::rememberForever('ad_unit_top', function() {
                return Setting::where('name', 'ad_unit_top')->first();
            });
            View::share('ad_unit_top', $setting->body);

            $setting = Cache::rememberForever('ad_unit_right_1', function() {
                return Setting::where('name', 'ad_unit_right_1')->first();
            });
            View::share('ad_unit_right_1', $setting->body);

            $setting = Cache::rememberForever('ad_unit_right_2', function() {
                return Setting::where('name', 'ad_unit_right_2')->first();
            });
            View::share('ad_unit_right_2', $setting->body);

            $setting = Cache::rememberForever('ad_unit_comments_top', function() {
                return Setting::where('name', 'ad_unit_comments_top')->first();
            });
            View::share('ad_unit_comments_top', $setting->body);

            $setting = Cache::rememberForever('enable_seo_for_published_albums', function() {
                return Setting::where('name', 'enable_seo_for_published_albums')->first();
            });
            View::share('enable_seo_for_published_albums', $setting->body);

            $setting = Cache::rememberForever('pagination', function() {
                return Setting::where('name', 'pagination')->first();
            });
            View::share('pagination', $setting->body);

            $setting = Cache::rememberForever('version', function() {
                return Setting::where('name', 'version')->first();
            });
            View::share('app_version', $setting->body);

            $setting = Cache::rememberForever('max_upload_files', function() {
                return Setting::where('name', 'max_upload_files')->first();
            });
            View::share('max_upload_files', $setting->body);

            $setting = Cache::rememberForever('max_upload_file_size', function() {
                return Setting::where('name', 'max_upload_file_size')->first();
            });
            View::share('max_upload_file_size', $setting->body);

            $pages = Cache::rememberForever('pages', function() {
                return Page::active()->get();
            });
            View::share('pages', $pages);
        }
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
