<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laratrust\Traits\LaratrustUserTrait;
use Illuminate\Database\Eloquent\SoftDeletes;
// use App\Models\Favoritable;

class User extends Authenticatable
{
    use LaratrustUserTrait;
    use Notifiable;
    use Favoritable;
    use SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'username', 'email', 'password', 'deleted_by', 'blocked_by','blocked_at', 'reason',
    ];

    protected $dates = [
        'created_at',
        'deleted_at',
        'updated_at',
        'blocked_at',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public static function boot()
    {
        parent::boot();

        static::deleting(function ($model) {

            $model->votes()->delete();
            $model->favorites()->delete();
            $model->comments()->delete();

            foreach ($model->albums()->get() as $album) {
                $album->reason = $model->reason;
                $album->deleted_by = $model->deleted_by;
                $album->save();
                $album->delete();
            }
        });
   }

   public function votes()
   {
       return $this->hasMany(Vote::class);
   }

    public function comments()
    {
        return $this->hasMany(Comment::class);
    }

    public function albums()
    {
        return $this->hasMany(Album::class);
    }

    public function images(){
        return $this->hasMany(Image::class);
    }

}
