<?php
namespace App\Models;

use Auth;

trait Reportable{

    public function reports()
    {
        return $this->morphMany(Report::class, 'reportable');
    }

    public function checkIfReported(User $user)
    {
        return $this->reports()->where('reported_by', $user->id)->exists();
    }

    public function getReport(User $user)
    {
        return $this->reports()->where('reported_by', $user->id)->first();
    }

    public function report($reason)
    {
        $status = '';
        if(Auth::user() != null){
            $user = Auth::user();
            if(! $this->checkIfReported($user)){
                $report = new Report();
                $report->reported_by = Auth::user()->id;
                $report->reason = $reason;
                $this->reports()->save($report);
                $status = 'Successfully reported submission.';
            } else {
                $status = 'You have already reported this.';
            }
        } else {
            $status = false;
        }
        return $status;
    }
}
