<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Report extends Model
{
    use SoftDeletes;
    protected $fillable = ['reason', 'actions', 'reportable_id', 'reportable_type', 'reported_by', 'resolved_by'];

    protected $dates = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];

    // protected $with = [];

    protected $with = ['reportable.images', 'reportable.creator'];

    public function reportable()
    {
        return $this->morphTo();
    }

}
//
