<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class RemovalRequest extends Model
{
    use SoftDeletes;

    protected $table = 'requests';

    protected $fillable = ['images', 'email', 'action', 'message', 'closed_by'];

    protected $dates = [
        'created_at',
        'deleted_at',
        'updated_at',
    ];

    public function closedBy()
    {
        return $this->belongsTo(User::class, 'closed_by');
    }
}
